/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.filters;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;

@PreMatching
@Priority(value=5100)
public class AliasFilter
implements ContainerRequestFilter {
    private final SchemaRegistry schemaRegistry;

    @Inject
    public AliasFilter(SchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String path = requestContext.getUriInfo().getPath(false);
        UriBuilder builder = requestContext.getUriInfo().getRequestUriBuilder();
        MultivaluedMap queryParams = requestContext.getUriInfo().getQueryParameters(false);
        URI uri = this.modifyUri(builder, path, (MultivaluedMap<String, String>)queryParams);
        requestContext.setRequestUri(uri);
    }

    @VisibleForTesting
    URI modifyUri(UriBuilder builder, String path, MultivaluedMap<String, String> queryParams) {
        String modifiedPath = this.modifyUriPath(path);
        builder.replacePath(modifiedPath);
        this.replaceQueryParams(builder, modifiedPath, queryParams);
        return builder.build(new Object[0]);
    }

    @VisibleForTesting
    String modifyUriPath(String path) {
        boolean subjectPathFound = false;
        StringBuilder modifiedPath = new StringBuilder();
        for (String uriPathStr : path.split("/")) {
            if (uriPathStr.isEmpty()) continue;
            modifiedPath.append("/");
            String modifiedUriPathStr = uriPathStr;
            if (subjectPathFound) {
                modifiedUriPathStr = this.replaceAlias(uriPathStr);
                subjectPathFound = false;
            }
            if (uriPathStr.equals("subjects") || uriPathStr.equals("deks")) {
                subjectPathFound = true;
            }
            modifiedPath.append(modifiedUriPathStr);
        }
        if (path.endsWith("/")) {
            modifiedPath.append("/");
        }
        return modifiedPath.toString();
    }

    private void replaceQueryParams(UriBuilder builder, String path, MultivaluedMap<String, String> queryParams) {
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.startsWith("schemas/ids")) {
            String subject = (String)queryParams.getFirst((Object)"subject");
            if (subject == null) {
                subject = "";
            }
            builder.replaceQueryParam("subject", new Object[]{this.replaceAlias(subject)});
        }
    }

    private String replaceAlias(String subject) {
        String originalSubject;
        if (subject.isEmpty()) {
            return subject;
        }
        String tenant = this.schemaRegistry.tenant();
        boolean isQualified = QualifiedSubject.isQualified((String)tenant, (String)(originalSubject = subject));
        if (!isQualified) {
            subject = QualifiedSubject.createFromUnqualified((String)tenant, (String)originalSubject).toQualifiedSubject();
        }
        Config config = null;
        try {
            config = this.schemaRegistry.getConfig(URLDecoder.decode(subject, "UTF-8"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (config == null) {
            return originalSubject;
        }
        String alias = config.getAlias();
        if (alias != null && !alias.isEmpty()) {
            QualifiedSubject qualAlias = QualifiedSubject.qualifySubjectWithParent((String)tenant, (String)subject, (String)alias, (boolean)true);
            return isQualified ? qualAlias.toQualifiedSubject() : qualAlias.toUnqualifiedSubject();
        }
        return originalSubject;
    }
}

