/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.resources;

import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaRegistryDeployment;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaRegistryServerVersion;
import io.confluent.kafka.schemaregistry.client.rest.entities.ServerClusterId;
import io.confluent.kafka.schemaregistry.rest.resources.DocumentedName;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.kafka.schemaregistry.utils.AppInfoParser;
import io.confluent.kafka.schemaregistry.utils.Props;
import io.confluent.rest.annotations.PerformanceMetric;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/metadata")
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json", "application/octet-stream"})
public class ServerMetadataResource {
    public static final String apiTag = "Server Metadata (v1)";
    private static final Logger log = LoggerFactory.getLogger(ServerMetadataResource.class);
    private final SchemaRegistry schemaRegistry;

    @Inject
    public ServerMetadataResource(SchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    @GET
    @Path(value="/id")
    @DocumentedName(value="getClusterId")
    @Operation(summary="Get the server metadata", responses={@ApiResponse(responseCode="500", description="Error code 50001 -- Error in the backend data store\n")})
    @Tags(value={@Tag(name="Server Metadata (v1)")})
    @PerformanceMetric(value="metadata.id")
    public ServerClusterId getClusterId() {
        String kafkaClusterId = this.schemaRegistry.getKafkaClusterId();
        String schemaRegistryClusterId = this.schemaRegistry.getGroupId();
        return ServerClusterId.of((String)kafkaClusterId, (String)schemaRegistryClusterId);
    }

    @GET
    @Path(value="/version")
    @DocumentedName(value="getSchemaRegistryServerVersion")
    @Operation(summary="Get Schema Registry server version", responses={@ApiResponse(responseCode="500", description="Error code 50001 -- Error in the backend data store\n")})
    @Tags(value={@Tag(name="Server Metadata (v1)")})
    @PerformanceMetric(value="metadata.version")
    public SchemaRegistryServerVersion getSchemaRegistryVersion() {
        return new SchemaRegistryServerVersion(AppInfoParser.getVersion(), AppInfoParser.getCommitId());
    }

    @GET
    @Path(value="/deployment")
    @DocumentedName(value="getSchemaRegistryServerDeployment")
    @Operation(summary="Get Schema Registry deployment", responses={@ApiResponse(responseCode="500", description="Error code 50001 -- Error in the backend data store\n")})
    @Tags(value={@Tag(name="Server Metadata (v1)")})
    @PerformanceMetric(value="metadata.deployment")
    public SchemaRegistryDeployment getSchemaRegistryDeployment() {
        return Props.getSchemaRegistryDeployment(this.schemaRegistry.properties());
    }
}

