/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.storage.CloseableIterator;
import java.util.function.Function;

public abstract class TransformedIterator<F, T>
implements CloseableIterator<T> {
    final CloseableIterator<? extends F> backingIterator;

    public static <F, T> CloseableIterator<T> transform(CloseableIterator<F> fromIterator, final Function<? super F, ? extends T> function) {
        return new TransformedIterator<F, T>(fromIterator){

            @Override
            T transform(F from) {
                return function.apply(from);
            }
        };
    }

    TransformedIterator(CloseableIterator<? extends F> backingIterator) {
        this.backingIterator = backingIterator;
    }

    abstract T transform(F var1);

    @Override
    public final boolean hasNext() {
        return this.backingIterator.hasNext();
    }

    @Override
    public final T next() {
        return this.transform(this.backingIterator.next());
    }

    @Override
    public final void remove() {
        this.backingIterator.remove();
    }

    @Override
    public final void close() {
        this.backingIterator.close();
    }
}

