/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.schema.id;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.utils.ByteUtils;

public class SchemaId {
    public static final String KEY_SCHEMA_ID_HEADER = "__key_schema_id";
    public static final String VALUE_SCHEMA_ID_HEADER = "__value_schema_id";
    public static final int ID_SIZE = 4;
    public static final byte MAGIC_BYTE_V0 = 0;
    public static final byte MAGIC_BYTE_V1 = 1;
    private final String schemaType;
    private Integer id;
    private UUID guid;
    private SchemaMessageIndexes messageIndexes;

    public SchemaId(String schemaType) {
        this.schemaType = schemaType;
    }

    public SchemaId(String schemaType, Integer id, UUID guid) {
        this.schemaType = schemaType;
        this.id = id;
        this.guid = guid;
    }

    public SchemaId(String schemaType, Integer id, String guid) {
        this.schemaType = schemaType;
        this.id = id;
        this.guid = guid != null ? UUID.fromString(guid) : null;
    }

    public ByteBuffer fromBytes(ByteBuffer buffer) {
        byte version = buffer.get();
        if (version == 0) {
            int id = buffer.getInt();
            this.setId(id);
        } else if (version == 1) {
            long msb = buffer.getLong();
            long lsb = buffer.getLong();
            this.setGuid(new UUID(msb, lsb));
        } else {
            throw new IllegalArgumentException("Unknown magic byte!");
        }
        if (this.getSchemaType().equals("PROTOBUF")) {
            this.setMessageIndexes(buffer);
        }
        return buffer;
    }

    public byte[] idToBytes() throws SerializationException {
        byte[] byArray;
        if (this.id == null) {
            throw new SerializationException("Schema ID is null");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(0);
            baos.write(ByteBuffer.allocate(4).putInt(this.getId()).array());
            if (!this.getMessageIndexes().isEmpty()) {
                byte[] indexes = this.getMessageIndexesAsBytes();
                baos.write(indexes);
            }
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new SerializationException("Error serializing schema ID", (Throwable)e);
            }
        }
        baos.close();
        return byArray;
    }

    public byte[] guidToBytes() throws SerializationException {
        byte[] byArray;
        if (this.guid == null) {
            throw new SerializationException("Schema GUID is null");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(1);
            ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
            bb.putLong(this.guid.getMostSignificantBits());
            bb.putLong(this.guid.getLeastSignificantBits());
            baos.write(bb.array());
            if (!this.getMessageIndexes().isEmpty()) {
                byte[] indexes = this.getMessageIndexesAsBytes();
                baos.write(indexes);
            }
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new SerializationException("Error serializing schema GUID", (Throwable)e);
            }
        }
        baos.close();
        return byArray;
    }

    public String getSchemaType() {
        return this.schemaType;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public void setGuid(UUID guid) {
        this.guid = guid;
    }

    public List<Integer> getMessageIndexes() {
        return this.messageIndexes != null ? this.messageIndexes.indexes() : Collections.emptyList();
    }

    public byte[] getMessageIndexesAsBytes() {
        return this.messageIndexes != null ? this.messageIndexes.toByteArray() : new byte[]{};
    }

    public void setMessageIndexes(List<Integer> messageIndexes) {
        this.messageIndexes = new SchemaMessageIndexes(messageIndexes);
    }

    public void setMessageIndexes(byte[] bytes) {
        this.messageIndexes = SchemaMessageIndexes.readFrom(bytes);
    }

    public void setMessageIndexes(ByteBuffer buffer) {
        this.messageIndexes = SchemaMessageIndexes.readFrom(buffer);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaId schemaId = (SchemaId)o;
        return Objects.equals(this.schemaType, schemaId.schemaType) && Objects.equals(this.id, schemaId.id) && Objects.equals(this.guid, schemaId.guid) && Objects.equals(this.messageIndexes, schemaId.messageIndexes);
    }

    public int hashCode() {
        return Objects.hash(this.schemaType, this.id, this.guid, this.messageIndexes);
    }

    public String toString() {
        return "SchemaId{schemaType='" + this.schemaType + "', id=" + this.id + ", guid='" + String.valueOf(this.guid) + "', messageIndexes=" + String.valueOf(this.messageIndexes) + "}";
    }

    static class SchemaMessageIndexes {
        private static final List<Integer> DEFAULT_INDEX = Collections.singletonList(0);
        private static final byte[] DEFAULT_MSG_INDEXES = new byte[]{0};
        private final List<Integer> indexes;

        public SchemaMessageIndexes(List<Integer> indexes) {
            this.indexes = indexes;
        }

        public List<Integer> indexes() {
            return this.indexes;
        }

        public byte[] toByteArray() {
            if (this.indexes.equals(DEFAULT_INDEX)) {
                return DEFAULT_MSG_INDEXES;
            }
            int size = ByteUtils.sizeOfVarint((int)this.indexes.size());
            for (Integer index : this.indexes) {
                size += ByteUtils.sizeOfVarint((int)index);
            }
            ByteBuffer buffer = ByteBuffer.allocate(size);
            this.writeTo(buffer);
            return buffer.array();
        }

        public void writeTo(ByteBuffer buffer) {
            ByteUtils.writeVarint((int)this.indexes.size(), (ByteBuffer)buffer);
            for (Integer index : this.indexes) {
                ByteUtils.writeVarint((int)index, (ByteBuffer)buffer);
            }
        }

        public static SchemaMessageIndexes readFrom(byte[] bytes) {
            return SchemaMessageIndexes.readFrom(ByteBuffer.wrap(bytes));
        }

        public static SchemaMessageIndexes readFrom(ByteBuffer buffer) {
            int size = ByteUtils.readVarint((ByteBuffer)buffer);
            if (size == 0) {
                return new SchemaMessageIndexes(DEFAULT_INDEX);
            }
            ArrayList<Integer> indexes = new ArrayList<Integer>(size);
            for (int i = 0; i < size; ++i) {
                indexes.add(ByteUtils.readVarint((ByteBuffer)buffer));
            }
            return new SchemaMessageIndexes(indexes);
        }
    }
}

