/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.streams.serdes.avro;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;

public class PrimitiveAvroSerde<T>
implements Serde<T> {
    private final Serde<T> inner;

    public PrimitiveAvroSerde() {
        this.inner = Serdes.serdeFrom((Serializer)new KafkaAvroSerializer(), (Deserializer)new KafkaAvroDeserializer());
    }

    public PrimitiveAvroSerde(SchemaRegistryClient client) {
        if (client == null) {
            throw new IllegalArgumentException("schema registry client must not be null");
        }
        this.inner = Serdes.serdeFrom((Serializer)new KafkaAvroSerializer(client), (Deserializer)new KafkaAvroDeserializer(client));
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.inner.serializer().configure(configs, isKey);
        this.inner.deserializer().configure(configs, isKey);
    }

    public void close() {
        this.inner.serializer().close();
        this.inner.deserializer().close();
    }

    public Serializer<T> serializer() {
        return this.inner.serializer();
    }

    public Deserializer<T> deserializer() {
        return this.inner.deserializer();
    }
}

