/*
 * Copyright 2019 Confluent Inc.
 *
 * Licensed under the Confluent Community License (the "License"; you may not use
 * this file except in compliance with the License. You may obtain a copy of the
 * License at
 *
 * http://www.confluent.io/confluent-community-license
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OF ANY KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations under the License.
 */

package io.confluent.ksql.function.types;

public final class StringType extends ObjectType {

  public static final StringType INSTANCE = new StringType();

  private StringType() {
  }

  @Override
  public int hashCode() {
    return 6;
  }

  @Override
  public boolean equals(final Object obj) {
    return obj instanceof StringType;
  }

  @Override
  public String toString() {
    return "VARCHAR";
  }

}
