/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.errors;

import io.confluent.ksql.metrics.StreamsErrorCollector;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.streams.errors.DeserializationExceptionHandler;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogMetricAndContinueExceptionHandler
implements DeserializationExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(LogMetricAndContinueExceptionHandler.class);

    public DeserializationExceptionHandler.DeserializationHandlerResponse handle(ProcessorContext context, ConsumerRecord<byte[], byte[]> record, Exception exception) {
        log.debug("Exception caught during Deserialization, taskId: {}, topic: {}, partition: {}, offset: {}", new Object[]{context.taskId(), record.topic(), record.partition(), record.offset(), exception});
        StreamsErrorCollector.recordError(context.applicationId(), record.topic());
        return DeserializationExceptionHandler.DeserializationHandlerResponse.CONTINUE;
    }

    public void configure(Map<String, ?> configs) {
    }
}

