/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql;

import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.schema.ksql.types.SqlArray;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlDecimal;
import io.confluent.ksql.schema.ksql.types.SqlMap;
import io.confluent.ksql.schema.ksql.types.SqlPrimitiveType;
import io.confluent.ksql.schema.ksql.types.SqlStruct;
import io.confluent.ksql.schema.ksql.types.SqlType;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public final class SqlTypeWalker {
    private static final Map<SqlBaseType, BiFunction<Visitor<?, ?>, SqlType, Object>> HANDLER = ImmutableMap.builder().put((Object)SqlBaseType.BOOLEAN, (v, t) -> v.visitBoolean((SqlPrimitiveType)t)).put((Object)SqlBaseType.INTEGER, (v, t) -> v.visitInt((SqlPrimitiveType)t)).put((Object)SqlBaseType.BIGINT, (v, t) -> v.visitBigInt((SqlPrimitiveType)t)).put((Object)SqlBaseType.DOUBLE, (v, t) -> v.visitDouble((SqlPrimitiveType)t)).put((Object)SqlBaseType.STRING, (v, t) -> v.visitString((SqlPrimitiveType)t)).put((Object)SqlBaseType.DECIMAL, (v, t) -> v.visitDecimal((SqlDecimal)t)).put((Object)SqlBaseType.TIMESTAMP, (v, t) -> v.visitTimestamp((SqlPrimitiveType)t)).put((Object)SqlBaseType.ARRAY, SqlTypeWalker::visitArray).put((Object)SqlBaseType.MAP, SqlTypeWalker::visitMap).put((Object)SqlBaseType.STRUCT, SqlTypeWalker::visitStruct).build();

    private SqlTypeWalker() {
    }

    public static <S, F> S visit(SqlType type, Visitor<S, F> visitor) {
        BiFunction<Visitor<?, ?>, SqlType, Object> handler = HANDLER.get(type.baseType());
        if (handler == null) {
            throw new UnsupportedOperationException("Unsupported schema type: " + type.baseType());
        }
        return (S)handler.apply(visitor, type);
    }

    public static <S, F> F visit(SqlStruct.Field field, Visitor<S, F> visitor) {
        return SqlTypeWalker.visitField(visitor, field);
    }

    private static <S, F> S visitArray(Visitor<S, F> visitor, SqlType type) {
        SqlArray array = (SqlArray)type;
        S element = SqlTypeWalker.visit(array.getItemType(), visitor);
        return visitor.visitArray(array, element);
    }

    private static <S, F> S visitMap(Visitor<S, F> visitor, SqlType type) {
        SqlMap map = (SqlMap)type;
        S key = SqlTypeWalker.visit(map.getKeyType(), visitor);
        S value = SqlTypeWalker.visit(map.getValueType(), visitor);
        return visitor.visitMap(map, key, value);
    }

    private static <S, F> S visitStruct(Visitor<S, F> visitor, SqlType type) {
        SqlStruct struct = (SqlStruct)type;
        List fields = struct.fields().stream().map(field -> SqlTypeWalker.visitField(visitor, field)).collect(Collectors.toList());
        return visitor.visitStruct(struct, fields);
    }

    private static <S, F> F visitField(Visitor<S, F> visitor, SqlStruct.Field field) {
        S fieldType = SqlTypeWalker.visit(field.type(), visitor);
        return visitor.visitField(field, fieldType);
    }

    public static interface Visitor<S, F> {
        default public S visitType(SqlType schema) {
            throw new UnsupportedOperationException("Unsupported sql type: " + schema);
        }

        default public S visitPrimitive(SqlPrimitiveType type) {
            return this.visitType((SqlType)type);
        }

        default public S visitBoolean(SqlPrimitiveType type) {
            return this.visitPrimitive(type);
        }

        default public S visitInt(SqlPrimitiveType type) {
            return this.visitPrimitive(type);
        }

        default public S visitBigInt(SqlPrimitiveType type) {
            return this.visitPrimitive(type);
        }

        default public S visitDouble(SqlPrimitiveType type) {
            return this.visitPrimitive(type);
        }

        default public S visitString(SqlPrimitiveType type) {
            return this.visitPrimitive(type);
        }

        default public S visitDecimal(SqlDecimal type) {
            return this.visitType((SqlType)type);
        }

        default public S visitTimestamp(SqlPrimitiveType type) {
            return this.visitPrimitive(type);
        }

        default public S visitArray(SqlArray type, S element) {
            return this.visitType((SqlType)type);
        }

        default public S visitMap(SqlMap type, S key, S value) {
            return this.visitType((SqlType)type);
        }

        default public S visitStruct(SqlStruct type, List<? extends F> fields) {
            return this.visitType((SqlType)type);
        }

        default public F visitField(SqlStruct.Field field, S type) {
            return null;
        }
    }
}

