/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Set;

public enum SerdeFeature {
    SCHEMA_INFERENCE(new String[0]),
    WRAP_SINGLES("UNWRAP_SINGLES"),
    UNWRAP_SINGLES("WRAP_SINGLES");

    private final ImmutableSet<String> unvalidated;
    private ImmutableSet<SerdeFeature> incompatibleWith;

    private SerdeFeature(String ... incompatibleWith) {
        this.unvalidated = ImmutableSet.copyOf((Object[])incompatibleWith);
    }

    public Set<SerdeFeature> getIncompatibleWith() {
        return this.incompatibleWith;
    }

    private void validate() {
        this.incompatibleWith = (ImmutableSet)this.unvalidated.stream().map(SerdeFeature::valueOf).collect(ImmutableSet.toImmutableSet());
    }

    static {
        Arrays.stream(SerdeFeature.values()).forEach(SerdeFeature::validate);
    }
}

