/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.confluent.ksql.name.Name;
import io.confluent.ksql.schema.ksql.Column;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class TabularRow {
    private static final String CLIPPED = "...";
    private static final int MIN_CELL_WIDTH = 5;
    private final int cellWidth;
    private final List<String> columns;
    private final boolean isHeader;
    private final boolean shouldWrap;

    public static TabularRow createHeader(int width, List<Column> columns, boolean shouldWrap, int configuredCellWidth) {
        List<String> headings = columns.stream().map(Column::name).map(Name::text).collect(Collectors.toList());
        return new TabularRow(width, headings, true, shouldWrap, configuredCellWidth);
    }

    public static TabularRow createRow(int width, List<?> values, boolean shouldWrap, int configuredCellWidth) {
        return new TabularRow(width, values.stream().map(Objects::toString).collect(Collectors.toList()), false, shouldWrap, configuredCellWidth);
    }

    private TabularRow(int width, List<String> columns, boolean isHeader, boolean shouldWrap, int configuredCellWidth) {
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns"));
        this.isHeader = isHeader;
        boolean bl = this.shouldWrap = isHeader || shouldWrap;
        this.cellWidth = configuredCellWidth > 0 ? configuredCellWidth : (!columns.isEmpty() ? Math.max(width / columns.size() - 2, 5) : 5);
    }

    public String toString() {
        if (this.columns.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        if (this.isHeader) {
            TabularRow.separatingLine(builder, this.cellWidth, this.columns.size());
            builder.append('\n');
        }
        List split = this.columns.stream().map(col -> TabularRow.splitToFixed(col, this.cellWidth)).collect(Collectors.toList());
        int maxSplit = split.stream().mapToInt(List::size).max().orElse(0);
        List<List<String>> buffered = split.stream().map(s -> TabularRow.addUntil(s, TabularRow.createCell("", this.cellWidth), maxSplit)).collect(Collectors.toList());
        TabularRow.formatRow(builder, buffered, this.shouldWrap ? maxSplit : 1);
        if (this.isHeader) {
            builder.append('\n');
            TabularRow.separatingLine(builder, this.cellWidth, this.columns.size());
        }
        return builder.toString();
    }

    private static void formatRow(StringBuilder builder, List<List<String>> columns, int numRows) {
        for (int row = 0; row < numRows; ++row) {
            builder.append('|');
            for (int col = 0; col < columns.size(); ++col) {
                String colValue = columns.get(col).get(row);
                if (TabularRow.shouldClip(columns.get(col), numRows)) {
                    builder.append(colValue, 0, colValue.length() - CLIPPED.length()).append(CLIPPED).append('|');
                    continue;
                }
                builder.append(colValue).append('|');
            }
            if (row == numRows - 1) continue;
            builder.append('\n');
        }
    }

    private static boolean shouldClip(List<String> parts, int rowsToPrint) {
        return parts.size() > rowsToPrint && !parts.subList(rowsToPrint, parts.size()).stream().map(String::trim).allMatch(String::isEmpty);
    }

    private static List<String> splitToFixed(String value, int width) {
        return Splitter.fixedLength((int)width).splitToList((CharSequence)value).stream().map(line -> TabularRow.createCell(line, width)).collect(Collectors.toList());
    }

    private static void separatingLine(StringBuilder builder, int cellWidth, int numColumns) {
        builder.append("+");
        for (int i = 0; i < numColumns; ++i) {
            builder.append(Strings.repeat((String)"-", (int)cellWidth));
            builder.append("+");
        }
    }

    private static String createCell(String value, int width) {
        String format = "%-" + width + "s";
        return String.format(format, value);
    }

    private static <T> List<T> addUntil(List<T> source, T value, int desiredSize) {
        ArrayList<T> copy = new ArrayList<T>(source);
        while (copy.size() < desiredSize) {
            copy.add(value);
        }
        return copy;
    }
}

