/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.rest.entity.KsqlEntity;
import io.confluent.ksql.rest.entity.KsqlWarning;
import io.confluent.ksql.rest.entity.SimpleConnectorPluginInfo;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ConnectorPluginsList
extends KsqlEntity {
    private final ImmutableList<SimpleConnectorPluginInfo> connectorPlugins;

    @JsonCreator
    public ConnectorPluginsList(@JsonProperty(value="statementText") String statementText, @JsonProperty(value="warnings") List<KsqlWarning> warnings, @JsonProperty(value="connectorsPlugins") List<SimpleConnectorPluginInfo> connectorPlugins) {
        super(statementText, warnings);
        this.connectorPlugins = ImmutableList.copyOf((Collection)Objects.requireNonNull(connectorPlugins, "connectorPlugins"));
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="connectorPlugins is ImmutableList")
    public ImmutableList<SimpleConnectorPluginInfo> getConnectorsPlugins() {
        return this.connectorPlugins;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectorPluginsList that = (ConnectorPluginsList)o;
        return Objects.equals(this.connectorPlugins, that.connectorPlugins);
    }

    public int hashCode() {
        return Objects.hash(this.connectorPlugins);
    }
}

