/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.properties.PropertiesUtil;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSubTypes(value={})
public class KsqlRequest {
    private static final Logger LOG = LoggerFactory.getLogger(KsqlRequest.class);
    private final String ksql;
    private final ImmutableMap<String, Object> configOverrides;
    private final ImmutableMap<String, Object> requestProperties;
    private final ImmutableMap<String, Object> sessionVariables;
    private final Optional<Long> commandSequenceNumber;
    @JsonIgnore
    private String maskedKsql;

    public KsqlRequest(@JsonProperty(value="ksql") String ksql, @JsonProperty(value="streamsProperties") Map<String, ?> configOverrides, @JsonProperty(value="requestProperties") Map<String, ?> requestProperties, @JsonProperty(value="commandSequenceNumber") Long commandSequenceNumber) {
        this(ksql, configOverrides, requestProperties, null, commandSequenceNumber);
    }

    @JsonCreator
    public KsqlRequest(@JsonProperty(value="ksql") String ksql, @JsonProperty(value="streamsProperties") Map<String, ?> configOverrides, @JsonProperty(value="requestProperties") Map<String, ?> requestProperties, @JsonProperty(value="sessionVariables") Map<String, ?> sessionVariables, @JsonProperty(value="commandSequenceNumber") Long commandSequenceNumber) {
        this.ksql = ksql == null ? "" : ksql;
        this.configOverrides = configOverrides == null ? ImmutableMap.of() : ImmutableMap.copyOf(KsqlRequest.serializeClassValues(configOverrides));
        this.requestProperties = requestProperties == null ? ImmutableMap.of() : ImmutableMap.copyOf(KsqlRequest.serializeClassValues(requestProperties));
        this.sessionVariables = sessionVariables == null ? ImmutableMap.of() : ImmutableMap.copyOf(KsqlRequest.serializeClassValues(sessionVariables));
        this.commandSequenceNumber = Optional.ofNullable(commandSequenceNumber);
    }

    public String getMaskedKsql() {
        Objects.requireNonNull(this.maskedKsql);
        return this.maskedKsql;
    }

    @JsonProperty(value="ksql")
    public String getUnmaskedKsql() {
        return this.ksql;
    }

    public void setMaskedKsql(String maskedKsql) {
        this.maskedKsql = Objects.requireNonNull(maskedKsql, "maskedKsql");
    }

    @JsonProperty(value="streamsProperties")
    public Map<String, Object> getConfigOverrides() {
        return PropertiesUtil.coerceTypes(this.configOverrides, (boolean)false);
    }

    public Map<String, Object> getRequestProperties() {
        return PropertiesUtil.coerceTypes(this.requestProperties, (boolean)false);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="sessionVariables is ImmutableMap")
    public Map<String, Object> getSessionVariables() {
        return this.sessionVariables;
    }

    public Optional<Long> getCommandSequenceNumber() {
        return this.commandSequenceNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KsqlRequest)) {
            return false;
        }
        KsqlRequest that = (KsqlRequest)o;
        return Objects.equals(this.ksql, that.ksql) && Objects.equals(this.configOverrides, that.configOverrides) && Objects.equals(this.requestProperties, that.requestProperties) && Objects.equals(this.sessionVariables, that.sessionVariables) && Objects.equals(this.commandSequenceNumber, that.commandSequenceNumber);
    }

    public int hashCode() {
        return Objects.hash(this.ksql, this.configOverrides, this.requestProperties, this.sessionVariables, this.commandSequenceNumber);
    }

    public String toString() {
        String sql;
        String string = sql = Objects.isNull(this.maskedKsql) ? this.ksql : this.maskedKsql;
        if (Objects.isNull(this.maskedKsql)) {
            LOG.warn("maskedKsql is not set, default to unmasked one for toString which may leak sensitive information, If this is seen in a test, it may be expected depending on how the KsqlRequest was created. If seen in production, this is not expected. Please file a Github issue.");
        }
        return "KsqlRequest{ksql='" + sql + '\'' + ", configOverrides=" + this.configOverrides + ", requestProperties=" + this.requestProperties + ", sessionVariables=" + this.sessionVariables + ", commandSequenceNumber=" + this.commandSequenceNumber + '}';
    }

    private static Map<String, ?> serializeClassValues(Map<String, ?> properties) {
        return properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, kv -> {
            if (kv.getValue() instanceof Class) {
                return ((Class)kv.getValue()).getCanonicalName();
            }
            return kv.getValue();
        }));
    }
}

