/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import java.util.Objects;

@Immutable
@JsonIgnoreProperties(ignoreUnknown=true)
public final class QueryStateStoreId {
    private static final String SEPARATOR = "#";
    private final String queryApplicationId;
    private final String stateStoreName;

    public static QueryStateStoreId of(String queryApplicationId, String stateStoreName) {
        return new QueryStateStoreId(queryApplicationId, stateStoreName);
    }

    public static QueryStateStoreId of(String serializedKey) {
        return new QueryStateStoreId(serializedKey);
    }

    private QueryStateStoreId(String queryApplicationId, String stateStoreName) {
        this.queryApplicationId = queryApplicationId;
        this.stateStoreName = stateStoreName;
    }

    @JsonCreator
    public QueryStateStoreId(String serializedPair) {
        String[] parts = serializedPair.split("\\#");
        Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0);
        this.queryApplicationId = Objects.requireNonNull(parts[0]);
        this.stateStoreName = Objects.requireNonNull(parts[1]);
    }

    public String getQueryApplicationId() {
        return this.queryApplicationId;
    }

    public String getStateStoreName() {
        return this.stateStoreName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryStateStoreId that = (QueryStateStoreId)o;
        return Objects.equals(this.queryApplicationId, that.queryApplicationId) && Objects.equals(this.stateStoreName, that.stateStoreName);
    }

    public int hashCode() {
        return Objects.hash(this.queryApplicationId, this.stateStoreName);
    }

    @JsonValue
    public String toString() {
        return this.queryApplicationId + SEPARATOR + this.stateStoreName;
    }
}

