/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.Immutable;
import java.util.Objects;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorType;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Immutable
public class SimpleConnectorPluginInfo {
    private final String className;
    private final ConnectorType type;
    private final String version;

    @JsonCreator
    public SimpleConnectorPluginInfo(@JsonProperty(value="className") String className, @JsonProperty(value="type") ConnectorType type, @JsonProperty(value="version") String version) {
        this.className = Objects.requireNonNull(className, "className");
        this.type = type;
        this.version = version;
    }

    public String getClassName() {
        return this.className;
    }

    public ConnectorType getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleConnectorPluginInfo that = (SimpleConnectorPluginInfo)o;
        return Objects.equals(this.className, that.className) && this.type == that.type && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.type, this.version);
    }

    public String toString() {
        return "SimpleConnectorPluginInfo{className='" + this.className + '\'' + ", type=" + this.type + ", version='" + this.version + '\'' + '}';
    }
}

