/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest;

import io.confluent.ksql.rest.EndpointResponse;
import io.confluent.ksql.rest.ErrorMessages;
import io.confluent.ksql.rest.entity.KsqlEntityList;
import io.confluent.ksql.rest.entity.KsqlErrorMessage;
import io.confluent.ksql.rest.entity.KsqlStatementErrorMessage;
import io.confluent.ksql.util.KsqlSchemaRegistryNotConfiguredException;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Objects;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.kafka.common.errors.TopicAuthorizationException;

public final class Errors {
    private static final int HTTP_TO_ERROR_CODE_MULTIPLIER = 100;
    public static final int ERROR_CODE_MISDIRECTED_REQUEST = Errors.toErrorCode(HttpResponseStatus.MISDIRECTED_REQUEST.code());
    public static final int ERROR_CODE_BAD_REQUEST = Errors.toErrorCode(HttpResponseStatus.BAD_REQUEST.code());
    public static final int ERROR_CODE_BAD_STATEMENT = Errors.toErrorCode(HttpResponseStatus.BAD_REQUEST.code()) + 1;
    private static final int ERROR_CODE_QUERY_ENDPOINT = Errors.toErrorCode(HttpResponseStatus.BAD_REQUEST.code()) + 2;
    public static final int ERROR_CODE_MAX_PUSH_QUERIES_EXCEEDED = Errors.toErrorCode(HttpResponseStatus.BAD_REQUEST.code()) + 3;
    public static final int ERROR_CODE_HTTP2_ONLY = Errors.toErrorCode(HttpResponseStatus.BAD_REQUEST.code()) + 4;
    public static final int ERROR_CODE_INTERNAL_ONLY = Errors.toErrorCode(HttpResponseStatus.BAD_REQUEST.code()) + 5;
    public static final int ERROR_CODE_UNAUTHORIZED = Errors.toErrorCode(HttpResponseStatus.UNAUTHORIZED.code());
    public static final int ERROR_CODE_FORBIDDEN = Errors.toErrorCode(HttpResponseStatus.FORBIDDEN.code());
    public static final int ERROR_CODE_FORBIDDEN_KAFKA_ACCESS = Errors.toErrorCode(HttpResponseStatus.FORBIDDEN.code()) + 1;
    public static final int ERROR_CODE_SCHEMA_REGISTRY_UNCONFIGURED = Errors.toErrorCode(HttpResponseStatus.PRECONDITION_REQUIRED.code()) + 1;
    public static final int ERROR_CODE_NOT_FOUND = Errors.toErrorCode(HttpResponseStatus.NOT_FOUND.code());
    public static final int ERROR_CODE_COMMAND_QUEUE_CATCHUP_TIMEOUT = Errors.toErrorCode(HttpResponseStatus.SERVICE_UNAVAILABLE.code()) + 1;
    public static final int ERROR_CODE_SERVER_NOT_READY = Errors.toErrorCode(HttpResponseStatus.SERVICE_UNAVAILABLE.code()) + 2;
    public static final int ERROR_CODE_SERVER_SHUTTING_DOWN = Errors.toErrorCode(HttpResponseStatus.SERVICE_UNAVAILABLE.code()) + 3;
    public static final int ERROR_CODE_SERVER_SHUT_DOWN = Errors.toErrorCode(HttpResponseStatus.SERVICE_UNAVAILABLE.code()) + 4;
    public static final int ERROR_CODE_SERVER_ERROR = Errors.toErrorCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
    public static final int ERROR_CODE_TOO_MANY_REQUESTS = Errors.toErrorCode(HttpResponseStatus.TOO_MANY_REQUESTS.code());
    public static final int ERROR_CODE_ASSERTION_FAILED = Errors.toErrorCode(HttpResponseStatus.EXPECTATION_FAILED.code());
    private final ErrorMessages errorMessages;

    public static int toStatusCode(int errorCode) {
        return errorCode / 100;
    }

    public static int toErrorCode(int statusCode) {
        return statusCode * 100;
    }

    public static EndpointResponse notReady() {
        return EndpointResponse.create().status(HttpResponseStatus.SERVICE_UNAVAILABLE.code()).header(HttpHeaderNames.RETRY_AFTER.toString(), 10).entity(new KsqlErrorMessage(ERROR_CODE_SERVER_NOT_READY, "Server initializing")).build();
    }

    private EndpointResponse constructAccessDeniedFromKafkaResponse(String errorMessage) {
        return EndpointResponse.create().status(HttpResponseStatus.FORBIDDEN.code()).entity(new KsqlErrorMessage(ERROR_CODE_FORBIDDEN_KAFKA_ACCESS, errorMessage)).build();
    }

    private EndpointResponse constructSchemaRegistryNotConfiguredResponse(String errorMessage) {
        return EndpointResponse.create().status(HttpResponseStatus.PRECONDITION_REQUIRED.code()).entity(new KsqlErrorMessage(ERROR_CODE_SCHEMA_REGISTRY_UNCONFIGURED, errorMessage)).build();
    }

    public static EndpointResponse badRequest(String msg) {
        return EndpointResponse.create().status(HttpResponseStatus.BAD_REQUEST.code()).entity(new KsqlErrorMessage(ERROR_CODE_BAD_REQUEST, msg)).build();
    }

    public static EndpointResponse badRequest(Throwable t) {
        return EndpointResponse.create().status(HttpResponseStatus.BAD_REQUEST.code()).entity(new KsqlErrorMessage(ERROR_CODE_BAD_REQUEST, t)).build();
    }

    public static EndpointResponse badStatement(String msg, String statementText) {
        return Errors.badStatement(msg, statementText, new KsqlEntityList());
    }

    public static EndpointResponse badStatement(String msg, String statementText, KsqlEntityList entities) {
        return EndpointResponse.create().status(HttpResponseStatus.BAD_REQUEST.code()).entity(new KsqlStatementErrorMessage(ERROR_CODE_BAD_STATEMENT, msg, statementText, entities)).build();
    }

    public static EndpointResponse badStatement(Throwable t, String statementText) {
        return Errors.badStatement(t, statementText, new KsqlEntityList());
    }

    public static EndpointResponse badStatement(Throwable t, String statementText, KsqlEntityList entities) {
        return EndpointResponse.create().status(HttpResponseStatus.BAD_REQUEST.code()).entity(new KsqlStatementErrorMessage(ERROR_CODE_BAD_STATEMENT, t, statementText, entities)).build();
    }

    public static EndpointResponse queryEndpoint(String statementText) {
        return EndpointResponse.create().status(HttpResponseStatus.BAD_REQUEST.code()).entity(new KsqlStatementErrorMessage(ERROR_CODE_QUERY_ENDPOINT, "The following statement types should be issued to the websocket endpoint '/query':" + System.lineSeparator() + "\t* PRINT" + System.lineSeparator() + "\t* SELECT", statementText, new KsqlEntityList())).build();
    }

    public static EndpointResponse notFound(String msg) {
        return EndpointResponse.create().status(HttpResponseStatus.NOT_FOUND.code()).entity(new KsqlErrorMessage(ERROR_CODE_NOT_FOUND, msg)).build();
    }

    public static EndpointResponse serverErrorForStatement(Throwable t, String statementText) {
        return Errors.serverErrorForStatement(t, statementText, new KsqlEntityList());
    }

    public static EndpointResponse serverErrorForStatement(Throwable t, String statementText, KsqlEntityList entities) {
        return EndpointResponse.create().status(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).entity(new KsqlStatementErrorMessage(ERROR_CODE_SERVER_ERROR, t, statementText, entities)).build();
    }

    public static EndpointResponse commandQueueCatchUpTimeout(long cmdSeqNum) {
        String errorMsg = "Timed out while waiting for a previous command to execute. command sequence number: " + cmdSeqNum;
        return EndpointResponse.create().status(HttpResponseStatus.SERVICE_UNAVAILABLE.code()).entity(new KsqlErrorMessage(ERROR_CODE_COMMAND_QUEUE_CATCHUP_TIMEOUT, errorMsg)).build();
    }

    public static EndpointResponse serverShuttingDown() {
        return EndpointResponse.create().status(HttpResponseStatus.SERVICE_UNAVAILABLE.code()).entity(new KsqlErrorMessage(ERROR_CODE_SERVER_SHUTTING_DOWN, "The server is shutting down")).build();
    }

    public static EndpointResponse serverShutDown() {
        return EndpointResponse.create().status(HttpResponseStatus.SERVICE_UNAVAILABLE.code()).entity(new KsqlErrorMessage(ERROR_CODE_SERVER_SHUT_DOWN, "The server is shut down")).build();
    }

    public static EndpointResponse serverNotReady(KsqlErrorMessage error) {
        return EndpointResponse.create().status(HttpResponseStatus.SERVICE_UNAVAILABLE.code()).entity(error).build();
    }

    public static EndpointResponse tooManyRequests(String msg) {
        return EndpointResponse.create().status(HttpResponseStatus.TOO_MANY_REQUESTS.code()).entity(new KsqlErrorMessage(ERROR_CODE_TOO_MANY_REQUESTS, msg)).build();
    }

    public static EndpointResponse assertionFailedError(String errorMsg) {
        return EndpointResponse.create().status(HttpResponseStatus.EXPECTATION_FAILED.code()).entity(new KsqlErrorMessage(ERROR_CODE_ASSERTION_FAILED, errorMsg)).build();
    }

    public Errors(ErrorMessages errorMessages) {
        this.errorMessages = Objects.requireNonNull(errorMessages, "errorMessages");
    }

    public EndpointResponse accessDeniedFromKafkaResponse(Exception e) {
        return this.constructAccessDeniedFromKafkaResponse(this.errorMessages.kafkaAuthorizationErrorMessage(e));
    }

    public EndpointResponse schemaRegistryNotConfiguredResponse(Exception e) {
        return this.constructSchemaRegistryNotConfiguredResponse(this.errorMessages.schemaRegistryUnconfiguredErrorMessage(e));
    }

    public String kafkaAuthorizationErrorMessage(Exception e) {
        return this.errorMessages.kafkaAuthorizationErrorMessage(e);
    }

    public String transactionInitTimeoutErrorMessage(Exception e) {
        return this.errorMessages.transactionInitTimeoutErrorMessage(e);
    }

    public String commandRunnerDegradedIncompatibleCommandsErrorMessage() {
        return this.errorMessages.commandRunnerDegradedIncompatibleCommandsErrorMessage();
    }

    public String commandRunnerDegradedCorruptedErrorMessage() {
        return this.errorMessages.commandRunnerDegradedCorruptedErrorMessage();
    }

    public EndpointResponse generateResponse(Exception e, EndpointResponse defaultResponse) {
        if (ExceptionUtils.indexOfType((Throwable)e, TopicAuthorizationException.class) >= 0) {
            return this.accessDeniedFromKafkaResponse(e);
        }
        if (ExceptionUtils.indexOfType((Throwable)e, KsqlSchemaRegistryNotConfiguredException.class) >= 0) {
            return this.schemaRegistryNotConfiguredResponse(e);
        }
        return defaultResponse;
    }
}

