/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.rest.entity.KafkaTopicInfo;
import io.confluent.ksql.rest.entity.KsqlEntity;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class KafkaTopicsList
extends KsqlEntity {
    private final ImmutableList<KafkaTopicInfo> topics;

    @JsonCreator
    public KafkaTopicsList(@JsonProperty(value="statementText") String statementText, @JsonProperty(value="topics") Collection<KafkaTopicInfo> topics) {
        super(statementText);
        Preconditions.checkNotNull(topics, (Object)"topics field must not be null");
        this.topics = ImmutableList.copyOf(topics);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="topics is ImmutableList")
    public List<KafkaTopicInfo> getTopics() {
        return this.topics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KafkaTopicsList)) {
            return false;
        }
        KafkaTopicsList that = (KafkaTopicsList)o;
        return Objects.equals(this.getTopics(), that.getTopics());
    }

    public int hashCode() {
        return Objects.hash(this.getTopics());
    }
}

