/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import io.confluent.ksql.util.KsqlException;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum KsqlMediaType {
    KSQL_V1_JSON("application/vnd.ksql.v1+json"),
    KSQL_V1_PROTOBUF("application/vnd.ksql.v1+protobuf");

    public static final KsqlMediaType LATEST_FORMAT;
    public static final KsqlMediaType LATEST_FORMAT_PROTOBUF;
    private final int version;
    private final String mediaType;

    private KsqlMediaType(String mediaType) {
        this.mediaType = Objects.requireNonNull(mediaType, "mediaType");
        Matcher matcher = Pattern.compile("application/.+\\.v(?<version>\\d+)[^0-9]+.*").matcher(mediaType);
        if (!matcher.matches()) {
            throw new IllegalStateException("Invalid mediaType: " + mediaType);
        }
        this.version = Integer.parseInt(matcher.group("version"));
    }

    public int getVersion() {
        return this.version;
    }

    public String mediaType() {
        return this.mediaType;
    }

    public static KsqlMediaType parse(String mediaType) {
        return Arrays.stream(KsqlMediaType.values()).filter(mt -> mt.mediaType.equals(mediaType)).findFirst().orElseThrow(() -> new KsqlException("Unsupported media type: " + mediaType));
    }

    public static KsqlMediaType valueOf(String format, int version) {
        String name = "KSQL_V" + version + "_" + format.toUpperCase();
        return KsqlMediaType.valueOf(name);
    }

    static {
        LATEST_FORMAT = KSQL_V1_JSON;
        LATEST_FORMAT_PROTOBUF = KSQL_V1_PROTOBUF;
    }
}

