/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.rest.entity.TopicPartitionEntity;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.TaskMetadata;

@JsonIgnoreProperties(ignoreUnknown=true)
public class StreamsTaskMetadata {
    private final String taskId;
    private final Set<TopicOffset> topicOffsets;
    private final Optional<Long> timeCurrentIdlingStarted;

    @JsonCreator
    public StreamsTaskMetadata(@JsonProperty(value="taskId") String taskId, @JsonProperty(value="topicOffsets") Set<TopicOffset> topicOffsets, @JsonProperty(value="timeCurrentIdlingStarted") Optional<Long> timeCurrentIdlingStarted) {
        this.taskId = taskId;
        this.topicOffsets = ImmutableSet.copyOf(topicOffsets);
        this.timeCurrentIdlingStarted = timeCurrentIdlingStarted;
    }

    public static StreamsTaskMetadata fromStreamsTaskMetadata(TaskMetadata taskMetadata) {
        HashSet<TopicOffset> topicOffsets = new HashSet<TopicOffset>();
        for (TopicPartition topicPartition : taskMetadata.topicPartitions()) {
            topicOffsets.add(new TopicOffset(new TopicPartitionEntity(topicPartition.topic(), topicPartition.partition()), taskMetadata.endOffsets().getOrDefault(topicPartition, 0L), taskMetadata.committedOffsets().getOrDefault(topicPartition, 0L)));
        }
        return new StreamsTaskMetadata(taskMetadata.taskId().toString(), topicOffsets, taskMetadata.timeCurrentIdlingStarted());
    }

    public String getTaskId() {
        return this.taskId;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="topicOffsets is ImmutableSet")
    public Set<TopicOffset> getTopicOffsets() {
        return this.topicOffsets;
    }

    public Optional<Long> getTimeCurrentIdlingStarted() {
        return this.timeCurrentIdlingStarted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StreamsTaskMetadata)) {
            return false;
        }
        StreamsTaskMetadata that = (StreamsTaskMetadata)o;
        return Objects.equals(this.taskId, that.taskId) && Objects.equals(this.topicOffsets, that.topicOffsets) && Objects.equals(this.timeCurrentIdlingStarted, that.timeCurrentIdlingStarted);
    }

    public int hashCode() {
        return Objects.hash(this.taskId, this.topicOffsets, this.timeCurrentIdlingStarted);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TopicOffset {
        private final TopicPartitionEntity topicPartitionEntity;
        private final Long endOffset;
        private final Long committedOffset;

        @JsonCreator
        TopicOffset(@JsonProperty(value="topicPartitionEntity") TopicPartitionEntity topicPartitionEntity, @JsonProperty(value="endOffset") Long endOffset, @JsonProperty(value="committedOffset") Long committedOffset) {
            this.topicPartitionEntity = topicPartitionEntity;
            this.endOffset = endOffset;
            this.committedOffset = committedOffset;
        }

        public TopicPartitionEntity getTopicPartitionEntity() {
            return this.topicPartitionEntity;
        }

        public Long getCommittedOffset() {
            return this.committedOffset;
        }

        public Long getEndOffset() {
            return this.endOffset;
        }
    }
}

