/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacperf;

import io.confluent.rbacapi.utils.ClusterType;
import io.confluent.rbacperf.RoleBindingTemplate;
import io.confluent.rbacperf.Team;
import io.confluent.security.authorizer.Scope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import utils.ScopeBuilder;

class ClusterPod {
    private String podName;
    private Team ownerTeam;
    private List<Cluster> clusters = new ArrayList<Cluster>();
    private int resourceBucketsPerCluster;
    private Map<String, Integer> resourceTypesPerBucket;

    ClusterPod(String podName, Team ownerTeam, Map<ClusterType, Integer> clustersPerPod, int resourceBucketsPerCluster, Map<String, Integer> resourceTypesPerBucket) {
        int i;
        this.podName = podName;
        this.ownerTeam = ownerTeam;
        this.resourceBucketsPerCluster = resourceBucketsPerCluster;
        this.resourceTypesPerBucket = resourceTypesPerBucket;
        for (i = 0; i < clustersPerPod.get(ClusterType.KAFKA_CLUSTER); ++i) {
            this.clusters.add(new KafkaCluster(String.format("kafka%02d", i), this));
        }
        for (i = 0; i < clustersPerPod.get(ClusterType.CONNECT_CLUSTER); ++i) {
            this.clusters.add(new ConnectCluster(String.format("connect%02d", i), this));
        }
        for (i = 0; i < clustersPerPod.get(ClusterType.KSQL_CLUSTER); ++i) {
            this.clusters.add(new KsqlCluster(String.format("ksql%02d", i), this));
        }
        for (i = 0; i < clustersPerPod.get(ClusterType.SCHEMA_REGISTRY_CLUSTER); ++i) {
            this.clusters.add(new SrCluster(String.format("sr%02d", i), this));
        }
    }

    private String getName() {
        if (this.ownerTeam != null) {
            return String.format("%s_%s", this.ownerTeam.getName(), this.podName);
        }
        return this.podName;
    }

    List<Cluster> getClusters() {
        return this.clusters;
    }

    List<Cluster> getOneClusterOfEachType() {
        HashMap<ClusterType, Cluster> byType = new HashMap<ClusterType, Cluster>();
        for (Cluster cluster : this.clusters) {
            byType.putIfAbsent(cluster.clusterType, cluster);
        }
        return new ArrayList<Cluster>(byType.values());
    }

    List<Scope> getScopes() {
        return this.clusters.stream().map(Cluster::getScope).collect(Collectors.toList());
    }

    Team getOwnerTeam() {
        return this.ownerTeam;
    }

    private KafkaCluster getFirstKafkaCluster() {
        for (Cluster cluster : this.clusters) {
            if (!(cluster instanceof KafkaCluster)) continue;
            return (KafkaCluster)cluster;
        }
        return null;
    }

    class SrResourceBucket
    extends ResourceBucket {
        SrResourceBucket(String name, SrCluster cluster) {
            super(name, cluster);
            this.addResources("Subject", (Integer)ClusterPod.this.resourceTypesPerBucket.get("Subject"));
        }
    }

    class KsqlResourceBucket
    extends ResourceBucket {
        KsqlResourceBucket(String name, KsqlCluster cluster) {
            super(name, cluster);
        }
    }

    class ConnectResourceBucket
    extends ResourceBucket {
        ConnectResourceBucket(String name, ConnectCluster cluster) {
            super(name, cluster);
            this.addResources("Connector", (Integer)ClusterPod.this.resourceTypesPerBucket.get("Connector"));
        }
    }

    class KafkaResourceBucket
    extends ResourceBucket {
        KafkaResourceBucket(String name, KafkaCluster cluster) {
            super(name, cluster);
            this.addResources("Topic", (Integer)ClusterPod.this.resourceTypesPerBucket.get("Topic"));
            this.addResources("Group", (Integer)ClusterPod.this.resourceTypesPerBucket.get("Group"));
            this.addResources("TransactionalId", (Integer)ClusterPod.this.resourceTypesPerBucket.get("TransactionalId"));
        }
    }

    abstract class ResourceBucket
    implements RoleBindingTemplate.Grantable.RegularResource {
        private String name;
        private Cluster cluster;
        private Map<String, List<String>> resources = new HashMap<String, List<String>>();

        ResourceBucket(String name, Cluster cluster) {
            this.name = name;
            this.cluster = cluster;
        }

        protected void addResources(String resourceType, int count) {
            this.resources.put(resourceType, Stream.iterate(0, n -> n + 1).limit(count).map(i -> String.format("%s_%s%05d", this.getName(), resourceType, i)).collect(Collectors.toList()));
        }

        @Override
        public List<String> getResources() {
            return this.resources.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        }

        List<String> getResourceTypes() {
            return new ArrayList<String>(this.resources.keySet());
        }

        @Override
        public List<String> getResourcesOfType(String type) {
            return this.resources.get(type);
        }

        @Override
        public String getName() {
            return String.format("%s_%s", this.cluster.getName(), this.name);
        }

        Cluster getCluster() {
            return this.cluster;
        }
    }

    class SrCluster
    extends Cluster {
        SrCluster(String name, ClusterPod clusterPod) {
            super(name, clusterPod);
            this.scope = ScopeBuilder.withKafka((String)clusterPod.getFirstKafkaCluster().getName()).withSR(name).build();
            this.clusterType = ClusterType.SCHEMA_REGISTRY_CLUSTER;
            for (int i = 0; i < ClusterPod.this.resourceBucketsPerCluster; ++i) {
                this.resourceBuckets.add(new SrResourceBucket(String.format("bucket%02d", i), this));
            }
        }
    }

    class KsqlCluster
    extends Cluster {
        KsqlCluster(String name, ClusterPod clusterPod) {
            super(name, clusterPod);
            this.scope = ScopeBuilder.withKafka((String)clusterPod.getFirstKafkaCluster().getName()).withKSQL(name).build();
            this.clusterType = ClusterType.KSQL_CLUSTER;
            for (int i = 0; i < ClusterPod.this.resourceBucketsPerCluster; ++i) {
                this.resourceBuckets.add(new KsqlResourceBucket(String.format("bucket%02d", i), this));
            }
        }
    }

    class ConnectCluster
    extends Cluster {
        ConnectCluster(String name, ClusterPod clusterPod) {
            super(name, clusterPod);
            this.scope = ScopeBuilder.withKafka((String)clusterPod.getFirstKafkaCluster().getName()).withConnect(name).build();
            this.clusterType = ClusterType.CONNECT_CLUSTER;
            for (int i = 0; i < ClusterPod.this.resourceBucketsPerCluster; ++i) {
                this.resourceBuckets.add(new ConnectResourceBucket(String.format("bucket%02d", i), this));
            }
        }
    }

    class KafkaCluster
    extends Cluster {
        KafkaCluster(String name, ClusterPod clusterPod) {
            super(name, clusterPod);
            this.scope = ScopeBuilder.withKafka((String)this.getName()).build();
            this.clusterType = ClusterType.KAFKA_CLUSTER;
            for (int i = 0; i < ClusterPod.this.resourceBucketsPerCluster; ++i) {
                this.resourceBuckets.add(new KafkaResourceBucket(String.format("bucket%02d", i), this));
            }
        }
    }

    abstract class Cluster
    implements RoleBindingTemplate.Grantable.ClusterResource {
        List<ResourceBucket> resourceBuckets = new ArrayList<ResourceBucket>();
        ClusterPod clusterPod;
        String name;
        Scope scope;
        ClusterType clusterType;

        Cluster(String name, ClusterPod clusterPod) {
            this.name = name;
            this.clusterPod = clusterPod;
        }

        Scope getScope() {
            return this.scope;
        }

        @Override
        public String getName() {
            return String.format("%s_%s", this.clusterPod.getName(), this.name);
        }

        List<ResourceBucket> getResourceBuckets() {
            return this.resourceBuckets;
        }
    }
}

