/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacperf;

import io.confluent.rbacperf.RoleBindingTemplate;
import io.confluent.rbacperf.World;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RoleBindingStore {
    private List<RoleBindingTemplate> allRoleBindingTemplates = new ArrayList<RoleBindingTemplate>();
    private Map<RoleBindingTemplate.Grantable, Map<World.Role, List<RoleBindingTemplate.Grantee>>> rolesOnGrantable = new HashMap<RoleBindingTemplate.Grantable, Map<World.Role, List<RoleBindingTemplate.Grantee>>>();
    private Map<RoleBindingTemplate.Grantee, Map<World.Role, List<RoleBindingTemplate.Grantable>>> rolesForGrantee = new HashMap<RoleBindingTemplate.Grantee, Map<World.Role, List<RoleBindingTemplate.Grantable>>>();

    synchronized void addToMappings(RoleBindingTemplate roleBindingTemplate) {
        World.Role role = roleBindingTemplate.getRole();
        RoleBindingTemplate.Grantable resource = roleBindingTemplate.getGrantable();
        this.allRoleBindingTemplates.add(roleBindingTemplate);
        this.rolesOnGrantable.computeIfAbsent(resource, k -> new HashMap());
        this.rolesOnGrantable.get(resource).computeIfAbsent(role, k -> new ArrayList());
        RoleBindingTemplate.Grantee principal = roleBindingTemplate.getGrantee();
        this.rolesOnGrantable.get(resource).get((Object)role).add(principal);
        this.rolesForGrantee.computeIfAbsent(principal, k -> new HashMap());
        this.rolesForGrantee.get(principal).computeIfAbsent(role, k -> new ArrayList());
        this.rolesForGrantee.get(principal).get((Object)role).add(resource);
    }

    Map<World.Role, List<RoleBindingTemplate.Grantable>> getRoleBindingsForPrincipal(RoleBindingTemplate.Grantee grantee) {
        return this.rolesForGrantee.get(grantee);
    }

    Map<World.Role, List<RoleBindingTemplate.Grantee>> getRoleBindingsOnResource(RoleBindingTemplate.Grantable grantable) {
        return this.rolesOnGrantable.get(grantable);
    }

    public String toString() {
        return this.allRoleBindingTemplates.stream().map(RoleBindingTemplate::toString).collect(Collectors.joining("\n"));
    }

    List<RoleBindingTemplate> getAllRoleBindingTemplates() {
        return this.allRoleBindingTemplates;
    }
}

