/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacperf;

import io.confluent.rbacperf.ClusterPod;
import io.confluent.rbacperf.World;
import java.util.Arrays;
import java.util.List;

public class RoleBindingTemplate {
    private World.Role role;
    private Grantee grantee;
    private Grantable grantable;

    RoleBindingTemplate(Grantee grantee, World.Role role, Grantable grantable) throws Exception {
        this.grantee = grantee;
        this.role = role;
        this.grantable = grantable;
        this.validateRoleCompatibilityWithGrantable(role, grantable);
    }

    private void validateRoleCompatibilityWithGrantable(World.Role role, Grantable grantable) {
        if (!grantable.getValidRoles().contains((Object)role)) {
            throw new RuntimeException(String.format("Can't grant role %s on resource %s", role.toString(), grantable.getName()));
        }
    }

    World.Role getRole() {
        return this.role;
    }

    Grantable getGrantable() {
        return this.grantable;
    }

    Grantee getGrantee() {
        return this.grantee;
    }

    public String toString() {
        if (this.grantable instanceof ClusterPod.Cluster) {
            return String.format("%s == %s == %s", this.grantee.getName(), this.role.toString(), this.grantable.getName());
        }
        return String.format("%s == %s == ResourceBucket %s [Cluster %s]", this.grantee.getName(), this.role.toString(), this.grantable.getName(), ((ClusterPod.ResourceBucket)this.grantable).getCluster().getName());
    }

    static interface Grantee {
        public String getName();

        public List<String> getUsers();
    }

    static interface Grantable {
        public String getName();

        public List<World.Role> getValidRoles();

        public static interface RegularResource
        extends Grantable {
            public static final List<World.Role> validRoles = Arrays.asList(World.Role.DeveloperRead, World.Role.DeveloperWrite, World.Role.DeveloperManage, World.Role.ResourceOwner);

            @Override
            default public List<World.Role> getValidRoles() {
                return validRoles;
            }

            public List<String> getResources();

            public List<String> getResourcesOfType(String var1);
        }

        public static interface ClusterResource
        extends Grantable {
            public static final List<World.Role> validRoles = Arrays.asList(World.Role.ClusterAdmin, World.Role.UserAdmin, World.Role.SecurityAdmin, World.Role.SystemAdmin, World.Role.Operator);

            @Override
            default public List<World.Role> getValidRoles() {
                return validRoles;
            }
        }
    }
}

