/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacperf;

import io.confluent.rbacperf.ClusterPod;
import io.confluent.rbacperf.RoleBindingStore;
import io.confluent.rbacperf.RoleBindingTemplate;
import io.confluent.rbacperf.World;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class Team {
    private String name;
    Team parent;
    private int depthInOrgTree;
    private List<Team> children = new ArrayList<Team>();
    private Map<World.Role, UserBucket> roleToUserBucket = new HashMap<World.Role, UserBucket>();
    private RoleBindingStore roleBindingStore;
    private ClusterPod clusterPodForThisTeam;
    private List<ClusterPod> otherClusterPodsThisTeamHasAccessTo = new ArrayList<ClusterPod>();

    Team(String name, Team parent, Map<World.Role, Integer> userCountPerRole, RoleBindingStore roleBindingStore) {
        this.name = name;
        if (parent != null) {
            this.parent = parent;
            this.parent.children.add(this);
        }
        this.depthInOrgTree = parent == null ? 0 : parent.depthInOrgTree + 1;
        for (World.Role role : World.Role.values()) {
            UserBucket userBucket = new UserBucket(role, userCountPerRole.get((Object)role), this);
            this.roleToUserBucket.put(role, userBucket);
        }
        this.roleBindingStore = roleBindingStore;
    }

    public String toString() {
        return String.format("Name: %s\nParent: %s\nDepth/level: %d\nnumber of children: %d\nuser buckets: %d", this.getName(), this.parent == null ? "null" : this.parent.getName(), this.depthInOrgTree, this.children.size(), this.roleToUserBucket.size());
    }

    public String getName() {
        if (this.parent == null) {
            return this.name;
        }
        return String.format("%s_%s", this.parent.getName(), this.name);
    }

    List<Team> getChildren() {
        return this.children;
    }

    public List<String> getUsers() {
        return this.roleToUserBucket.values().stream().map(UserBucket::getUsers).flatMap(Collection::stream).collect(Collectors.toList());
    }

    List<String> getUsersWithRole(World.Role role) {
        return this.roleToUserBucket.get((Object)role).getUsers();
    }

    List<String> getAllSubtreeUsers() {
        ArrayList<String> users = new ArrayList<String>();
        ArrayList<Team> stack = new ArrayList<Team>();
        stack.add(this);
        while (!stack.isEmpty()) {
            Team localTeam = (Team)stack.remove(stack.size() - 1);
            users.addAll(localTeam.getUsers());
            stack.addAll(localTeam.getChildren());
        }
        return users;
    }

    List<String> getAllSubtreeUsersWithRole(World.Role role) {
        ArrayList<String> users = new ArrayList<String>();
        ArrayList<Team> stack = new ArrayList<Team>();
        stack.add(this);
        while (!stack.isEmpty()) {
            Team localTeam = (Team)stack.remove(stack.size() - 1);
            users.addAll(localTeam.getUsersWithRole(role));
            stack.addAll(localTeam.getChildren());
        }
        return users;
    }

    List<UserBucket> getUserBuckets() {
        return new ArrayList<UserBucket>(this.roleToUserBucket.values());
    }

    UserBucket getUserBucketWithRole(World.Role role) {
        return this.roleToUserBucket.get((Object)role);
    }

    void setPrimaryClusterPod(ClusterPod clusterPodForThisTeam) {
        this.clusterPodForThisTeam = clusterPodForThisTeam;
    }

    ClusterPod getPrimaryClusterPod() {
        return this.clusterPodForThisTeam;
    }

    void addSecondaryClusterPod(ClusterPod clusterPod) {
        this.otherClusterPodsThisTeamHasAccessTo.add(clusterPod);
    }

    List<ClusterPod> getSecondaryClusterPods() {
        return this.otherClusterPodsThisTeamHasAccessTo;
    }

    int getLevel() {
        return this.depthInOrgTree;
    }

    void addClusterRoleBindings() throws Exception {
        if (this.clusterPodForThisTeam != null) {
            this.addRoleBindingsInternal(this.clusterPodForThisTeam);
        }
        for (ClusterPod clusterPod : this.otherClusterPodsThisTeamHasAccessTo) {
            this.addRoleBindingsInternal(clusterPod);
        }
    }

    private void addRoleBindingsInternal(ClusterPod clusterPod) throws Exception {
        for (ClusterPod.Cluster cluster : clusterPod.getClusters()) {
            for (World.Role role : RoleBindingTemplate.Grantable.ClusterResource.validRoles) {
                UserBucket userBucket = this.getUserBucketWithRole(role);
                this.roleBindingStore.addToMappings(new RoleBindingTemplate(userBucket, role, cluster));
            }
            for (ClusterPod.ResourceBucket resourceBucket : cluster.getResourceBuckets()) {
                for (World.Role role : RoleBindingTemplate.Grantable.RegularResource.validRoles) {
                    UserBucket userBucket = this.getUserBucketWithRole(role);
                    this.roleBindingStore.addToMappings(new RoleBindingTemplate(userBucket, role, resourceBucket));
                }
            }
        }
    }

    static class UserBucket
    implements RoleBindingTemplate.Grantee {
        private World.Role role;
        private String name;
        private Team parent;
        private List<String> users;

        UserBucket(World.Role role, int numUsers, Team parentTeam) {
            this.role = role;
            this.name = role.toString();
            this.parent = parentTeam;
            String fullName = this.getName();
            this.users = IntStream.range(0, numUsers).mapToObj(i -> String.format("%s_user%03d", fullName, i)).collect(Collectors.toList());
        }

        @Override
        public List<String> getUsers() {
            return this.users;
        }

        @Override
        public String getName() {
            return String.format("%s_%s", this.parent.getName(), this.name);
        }

        public String toString() {
            return String.format("%s: %s", this.getName(), this.users);
        }
    }
}

