/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacperf;

import io.confluent.rbacapi.utils.ClusterType;
import io.confluent.rbacperf.ClusterPod;
import io.confluent.rbacperf.LdapPopulator;
import io.confluent.rbacperf.MdsPopulator;
import io.confluent.rbacperf.RoleBindingStore;
import io.confluent.rbacperf.Team;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class World {
    Map<Role, Integer> userCountPerRole;
    Map<ClusterType, Integer> clustersPerPod;
    private Map<String, Integer> resourceTypesPerBucket;
    private int resourceBucketsPerCluster;
    private int width;
    private int depth;
    private LdapPopulator ldapPopulator;
    private MdsPopulator mdsPopulator;
    private boolean dryRun;
    private Team orgRoot;
    private Team vendor;
    private Map<Integer, List<Team>> teamsAtLevel = new HashMap<Integer, List<Team>>();
    private List<ClusterPod> clusterPods = new ArrayList<ClusterPod>();
    private ClusterPod specialClusterPodWithRestrictedAccess;
    RoleBindingStore roleBindingStore = new RoleBindingStore();
    private static List<String> prettyNames = Arrays.asList("country", "state", "county", "city", "district", "street", "building", "floor");

    World(int width, int depth, Map<Role, Integer> userCountPerRole, Map<ClusterType, Integer> clustersPerPod, int resourceBucketsPerCluster, Map<String, Integer> resourceTypesPerBucket, LdapPopulator ldapPopulator, MdsPopulator mdsPopulator, boolean dryRun) {
        this.width = width;
        this.depth = depth;
        this.userCountPerRole = userCountPerRole;
        this.clustersPerPod = clustersPerPod;
        this.resourceBucketsPerCluster = resourceBucketsPerCluster;
        this.resourceTypesPerBucket = resourceTypesPerBucket;
        this.ldapPopulator = ldapPopulator;
        this.mdsPopulator = mdsPopulator;
        this.dryRun = dryRun;
    }

    void initialize() throws Exception {
        this.createUsersGroupsAndClusters();
        if (!this.dryRun) {
            this.populateLdap();
            this.populateMds();
        }
    }

    List<Team> getTeamsIncreasingOrderOfRoleBindings() {
        return this.teamsAtLevel.keySet().stream().sorted(Comparator.reverseOrder()).map(level -> this.teamsAtLevel.get(level)).map(teams -> (Team)teams.get(0)).collect(Collectors.toList());
    }

    List<ClusterPod> getClusterPodsIncreasingOrderOfRoleBindings() {
        List<Team> teams = this.getTeamsIncreasingOrderOfRoleBindings();
        Collections.reverse(teams);
        return teams.stream().map(Team::getPrimaryClusterPod).collect(Collectors.toList());
    }

    List<Team> getTeamsAtLevel(int level) {
        return this.teamsAtLevel.get(level);
    }

    List<ClusterPod> getClusterPodsAtLevel(int level) {
        return this.teamsAtLevel.get(level).stream().map(Team::getPrimaryClusterPod).collect(Collectors.toList());
    }

    List<Team> getAllTeams() {
        List<Team> teams = this.getAllRegularTeams();
        teams.add(this.vendor);
        return teams;
    }

    List<ClusterPod> getAllClusterPods() {
        return Stream.concat(this.clusterPods.stream(), Stream.of(this.specialClusterPodWithRestrictedAccess)).collect(Collectors.toList());
    }

    Team getTeamWithNoRoleBindings() {
        return this.vendor;
    }

    ClusterPod getClusterPodsWithNoRoleBindings() {
        return this.specialClusterPodWithRestrictedAccess;
    }

    ClusterPod getClusterPodWithManyRoleBindings() {
        List<ClusterPod> clusterPods = this.getClusterPodsIncreasingOrderOfRoleBindings();
        return clusterPods.get(clusterPods.size() - 1);
    }

    Team getTeamsWithManyRoleBindings() {
        List<Team> teams = this.getTeamsIncreasingOrderOfRoleBindings();
        return teams.get(teams.size() - 1);
    }

    List<String> getAllUsers() {
        ArrayList<String> users = new ArrayList<String>();
        ArrayList<Team> stack = new ArrayList<Team>();
        stack.add(this.vendor);
        stack.add(this.orgRoot);
        while (!stack.isEmpty()) {
            Team team = (Team)stack.remove(stack.size() - 1);
            users.addAll(team.getUsers());
            stack.addAll(team.getChildren());
        }
        return users;
    }

    private List<Team> getAllRegularTeams() {
        return this.teamsAtLevel.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public int getWidth() {
        return this.width;
    }

    public int getDepth() {
        return this.depth;
    }

    /*
     * WARNING - void declaration
     */
    private void createUsersGroupsAndClusters() throws Exception {
        if (this.depth <= 0 || this.width <= 0) {
            throw new Exception("Both width and depth must be > 0.");
        }
        this.orgRoot = new Team("world", null, this.userCountPerRole, this.roleBindingStore);
        int currentLevel = 0;
        ArrayList<Team> arrayList = new ArrayList<Team>();
        arrayList.add(this.orgRoot);
        this.teamsAtLevel.put(currentLevel, arrayList);
        while (currentLevel < this.depth - 1) {
            void var2_6;
            ArrayList<Team> teamsAtNextLevel = new ArrayList<Team>();
            for (Team team : var2_6) {
                for (int i = 0; i < this.width; ++i) {
                    Team newTeam = new Team(String.format("%s%02d", World.getPrettyName(currentLevel), i), team, this.userCountPerRole, this.roleBindingStore);
                    teamsAtNextLevel.add(newTeam);
                }
            }
            ArrayList<Team> arrayList2 = teamsAtNextLevel;
            this.teamsAtLevel.put(++currentLevel, arrayList2);
        }
        this.vendor = new Team("vendor", null, this.userCountPerRole, this.roleBindingStore);
        for (Team team : this.getAllRegularTeams()) {
            ClusterPod clusterPod = new ClusterPod(String.format("%s_pod", team.getName()), team, this.clustersPerPod, this.resourceBucketsPerCluster, this.resourceTypesPerBucket);
            team.setPrimaryClusterPod(clusterPod);
            this.clusterPods.add(clusterPod);
        }
        for (int i = this.depth - 1; i >= 0; --i) {
            for (Team team : this.teamsAtLevel.get(i)) {
                ClusterPod clusterPod = team.getPrimaryClusterPod();
                Team parent = team.parent;
                while (parent != null) {
                    parent.addSecondaryClusterPod(clusterPod);
                    parent = parent.parent;
                }
            }
        }
        this.specialClusterPodWithRestrictedAccess = new ClusterPod("restricted_pod", null, this.clustersPerPod, this.resourceBucketsPerCluster, this.resourceTypesPerBucket);
        for (Team team : this.getAllRegularTeams()) {
            team.addClusterRoleBindings();
        }
    }

    private void populateLdap() {
        Team team;
        ArrayList<Team> stack = new ArrayList<Team>(Arrays.asList(this.vendor, this.orgRoot));
        while (!stack.isEmpty()) {
            team = (Team)stack.remove(stack.size() - 1);
            this.ldapPopulator.createLdapGroup(team.getName());
            this.ldapPopulator.createLdapUsers(team.getUsers());
            this.ldapPopulator.addUsersToLdapGroup(team.getUsers(), team.getName());
            for (Role role : Role.values()) {
                Team.UserBucket userBucket = team.getUserBucketWithRole(role);
                this.ldapPopulator.createLdapGroup(userBucket.getName());
                this.ldapPopulator.addUsersToLdapGroup(userBucket.getUsers(), userBucket.getName());
            }
            stack.addAll(team.getChildren());
        }
        stack = new ArrayList<Team>(Arrays.asList(this.vendor, this.orgRoot));
        while (!stack.isEmpty()) {
            team = (Team)stack.remove(stack.size() - 1);
            String groupName = team.getName() + "_All";
            this.ldapPopulator.createLdapGroup(groupName);
            this.ldapPopulator.addUsersToLdapGroup(team.getAllSubtreeUsers(), groupName);
            for (Role role : Role.values()) {
                String subGroupName = String.format("%s_All_%s", team.getName(), role.toString());
                this.ldapPopulator.createLdapGroup(subGroupName);
                this.ldapPopulator.addUsersToLdapGroup(team.getAllSubtreeUsersWithRole(role), subGroupName);
            }
            stack.addAll(team.getChildren());
        }
    }

    private void populateMds() {
        System.out.println(String.format("Creating %d rolebindings", this.roleBindingStore.getAllRoleBindingTemplates().size()));
        this.roleBindingStore.getAllRoleBindingTemplates().parallelStream().forEach(roleBinding -> {
            try {
                this.mdsPopulator.addRole(roleBinding.getGrantee(), roleBinding.getRole(), roleBinding.getGrantable());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    void cleanup() {
    }

    private static String getPrettyName(int level) {
        return level < prettyNames.size() ? prettyNames.get(level) : "node";
    }

    public static enum Role {
        DeveloperRead,
        DeveloperWrite,
        DeveloperManage,
        ResourceOwner,
        SystemAdmin,
        ClusterAdmin,
        UserAdmin,
        Operator,
        SecurityAdmin;

    }
}

