/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacperf;

import com.google.common.collect.ImmutableMap;
import io.confluent.rbacapi.utils.ClusterType;
import io.confluent.rbacperf.LdapPopulator;
import io.confluent.rbacperf.MdsPopulator;
import io.confluent.rbacperf.World;
import java.util.HashMap;
import java.util.Map;

public class WorldBuilder {
    private Map<World.Role, Integer> userCountPerRole = ImmutableMap.builder().put((Object)World.Role.DeveloperRead, (Object)40).put((Object)World.Role.DeveloperWrite, (Object)20).put((Object)World.Role.DeveloperManage, (Object)10).put((Object)World.Role.ResourceOwner, (Object)5).put((Object)World.Role.SystemAdmin, (Object)5).put((Object)World.Role.ClusterAdmin, (Object)5).put((Object)World.Role.UserAdmin, (Object)5).put((Object)World.Role.Operator, (Object)5).put((Object)World.Role.SecurityAdmin, (Object)5).build();
    private Map<ClusterType, Integer> clustersPerPod;
    private int resourceBucketsPerCluster;
    private Map<String, Integer> resourceTypesPerBucket;
    private int depth;
    private int width;
    private LdapPopulator ldapPopulator;
    private MdsPopulator mdsPopulator;
    private boolean dryRun = false;

    public static WorldBuilder withSize(int width, int depth) {
        WorldBuilder worldBuilder = new WorldBuilder();
        worldBuilder.depth = depth;
        worldBuilder.width = width;
        return worldBuilder.withClustersPerPod(10).withResourceBucketsPerCluster(10).withResourceCountForEachTypePerResourceBucket(100);
    }

    public WorldBuilder withUserCountPerRole(Map<World.Role, Integer> userCountPerRole) {
        this.userCountPerRole = userCountPerRole;
        return this;
    }

    public WorldBuilder withClustersPerPod(int clusterCount) {
        this.clustersPerPod = new HashMap<ClusterType, Integer>();
        for (ClusterType clusterType : ClusterType.values()) {
            this.clustersPerPod.put(clusterType, clusterCount);
        }
        return this;
    }

    public WorldBuilder withClustersPerPod(Map<ClusterType, Integer> clustersPerPod) {
        this.clustersPerPod = clustersPerPod;
        return this;
    }

    public WorldBuilder withResourceCountForEachTypePerResourceBucket(int resourceCount) {
        this.resourceTypesPerBucket = ImmutableMap.builder().put((Object)"Topic", (Object)resourceCount).put((Object)"Group", (Object)resourceCount).put((Object)"TransactionalId", (Object)resourceCount).put((Object)"Connector", (Object)resourceCount).put((Object)"Subject", (Object)resourceCount).build();
        return this;
    }

    public WorldBuilder withResourceTypesPerBucket(Map<String, Integer> resourceTypesPerBucket) {
        this.resourceTypesPerBucket = resourceTypesPerBucket;
        return this;
    }

    public WorldBuilder withResourceBucketsPerCluster(int resourceBucketsPerCluster) {
        this.resourceBucketsPerCluster = resourceBucketsPerCluster;
        return this;
    }

    public WorldBuilder withLdapPopulator(LdapPopulator ldapPopulator) {
        this.ldapPopulator = ldapPopulator;
        return this;
    }

    public WorldBuilder withMdsPopulator(MdsPopulator mdsPopulator) {
        this.mdsPopulator = mdsPopulator;
        return this;
    }

    public WorldBuilder withDryRun(boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public World build() throws Exception {
        World world = new World(this.width, this.depth, this.userCountPerRole, this.clustersPerPod, this.resourceBucketsPerCluster, this.resourceTypesPerBucket, this.ldapPopulator, this.mdsPopulator, this.dryRun);
        world.initialize();
        return world;
    }
}

