/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.oauthbearer;

import io.confluent.security.authentication.oauthbearer.Constraint;
import java.security.Key;
import java.util.Collection;
import java.util.List;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.UnresolvableKeyException;

public final class ConstrainedVerificationKeyResolver
implements VerificationKeyResolver {
    VerificationKeyResolver delegate;
    Collection<Constraint> constraints;

    public ConstrainedVerificationKeyResolver(VerificationKeyResolver keyResolver, Collection<Constraint> constraints) {
        this.delegate = keyResolver;
        this.constraints = constraints;
    }

    public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        for (Constraint interceptor : this.constraints) {
            interceptor.validate(jws);
        }
        try {
            return this.delegate.resolveKey(jws, nestingContext);
        }
        catch (NullPointerException e) {
            throw new UnresolvableKeyException("Failed to resolve key", (Throwable)e);
        }
    }

    public VerificationKeyResolver getDelegate() {
        return this.delegate;
    }
}

