/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.oidc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class RefreshTokenInfo {
    private final String issuer;
    private final String encryptedRefreshToken;
    private final long issuedAt;
    private final String subClaim;
    private final String sessionId;

    @JsonCreator
    public RefreshTokenInfo(@JsonProperty(value="issuer") String issuer, @JsonProperty(value="encryptedRefreshToken") String encryptedRefreshToken, @JsonProperty(value="issuedAt") long issuedAt, @JsonProperty(value="subClaim") String subClaim, @JsonProperty(value="sessionId") String sessionId) {
        this.issuer = issuer;
        this.encryptedRefreshToken = encryptedRefreshToken;
        this.issuedAt = issuedAt;
        this.subClaim = subClaim;
        this.sessionId = sessionId;
    }

    public String issuer() {
        return this.issuer;
    }

    public String encryptedRefreshToken() {
        return this.encryptedRefreshToken;
    }

    public long issuedAt() {
        return this.issuedAt;
    }

    public String subClaim() {
        return this.subClaim;
    }

    public String sessionId() {
        return this.sessionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RefreshTokenInfo)) {
            return false;
        }
        RefreshTokenInfo that = (RefreshTokenInfo)o;
        return Objects.equals(this.issuer, that.issuer) && Objects.equals(this.encryptedRefreshToken, that.encryptedRefreshToken) && Objects.equals(this.issuedAt, that.issuedAt) && Objects.equals(this.subClaim, that.subClaim) && Objects.equals(this.sessionId, that.sessionId);
    }

    public int hashCode() {
        return Objects.hash(this.issuer, this.encryptedRefreshToken, this.issuedAt, this.subClaim, this.sessionId);
    }

    public String toString() {
        return "RefreshTokenInfo{issuer='" + this.issuer + '\'' + ", encryptedRefreshToken='<sensitive>', issuedAt=" + this.issuedAt + ", subClaim='" + this.subClaim + '\'' + ", sessionId='" + this.sessionId + '\'' + '}';
    }
}

