/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.policyapi.cel;

import com.google.api.expr.v1alpha1.Decl;
import com.google.api.expr.v1alpha1.Type;
import io.confluent.security.policyapi.cel.TrustPolicyCelLibrary;
import io.confluent.security.policyapi.exception.PolicyEngineException;
import io.confluent.security.policyapi.exception.SyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.projectnessie.cel.Env;
import org.projectnessie.cel.EnvOption;
import org.projectnessie.cel.Program;
import org.projectnessie.cel.ProgramOption;
import org.projectnessie.cel.checker.Decls;
import org.projectnessie.cel.common.types.Err;
import org.projectnessie.cel.common.types.ref.TypeEnum;
import org.projectnessie.cel.common.types.ref.Val;

public class TrustPolicyCelParser {
    public static final String CLAIM_PREFIX = "claims";

    public static Env getTrustPolicyEnv() {
        ArrayList<Decl> decls = new ArrayList<Decl>();
        decls.add(Decls.newVar((String)CLAIM_PREFIX, (Type)Decls.newMapType((Type)Decls.String, (Type)Decls.Dyn)));
        EnvOption envOptionIdents = EnvOption.declarations(decls);
        EnvOption envOptionTrustServiceLib = TrustPolicyCelLibrary.customEnvOption();
        return Env.newCustomEnv((EnvOption[])new EnvOption[]{envOptionIdents, envOptionTrustServiceLib});
    }

    public static Program compilePolicy(Env env, String statements) throws PolicyEngineException {
        Env.AstIssuesTuple astIss;
        try {
            astIss = env.compile(statements);
        }
        catch (Throwable t) {
            throw new PolicyEngineException(String.format("Failed to load policy %s", statements), t);
        }
        if (astIss.hasIssues()) {
            throw new SyntaxException(astIss.getIssues().toString());
        }
        return env.program(astIss.getAst(), new ProgramOption[0]);
    }

    public static boolean evaluatePolicy(Program program, Map<String, Object> claims) throws PolicyEngineException {
        Program.EvalResult evalResult = program.eval(Collections.singletonMap(CLAIM_PREFIX, claims));
        if (Err.isError((Val)evalResult.getVal())) {
            return false;
        }
        Val value = evalResult.getVal();
        if (value.type().typeEnum() != TypeEnum.Bool) {
            throw new PolicyEngineException(String.format("Policy fails to evaluate as boolean: %s", program));
        }
        return value.booleanValue();
    }
}

