/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.oidc;

import com.fasterxml.jackson.annotation.JsonValue;
import io.confluent.security.authentication.oidc.TokenError;
import io.confluent.security.authentication.oidc.TokenRequest;
import io.confluent.security.authentication.oidc.TokenResponse;

public abstract class GrantBase {
    private TokenRequest tokenRequest;
    private TokenResponse tokenResponse;
    private TokenError tokenError;

    GrantBase(TokenRequest tokenRequest) {
        this.tokenRequest = tokenRequest;
    }

    public abstract GrantType getGrantType();

    public TokenRequest getTokenRequest() {
        return this.tokenRequest;
    }

    public TokenResponse getTokenResponse() {
        return this.tokenResponse;
    }

    public TokenError getTokenError() {
        return this.tokenError;
    }

    void setTokenRequest(TokenRequest request) {
        this.tokenRequest = request;
    }

    void setTokenResponse(TokenResponse tokenResponse) {
        this.tokenResponse = tokenResponse;
    }

    void setTokenError(TokenError tokenError) {
        this.tokenError = tokenError;
    }

    public static enum GrantType {
        CLIENT_CREDENTIALS("client_credentials");

        @JsonValue
        private final String grantType;

        private GrantType(String type) {
            this.grantType = type;
        }

        public String toString() {
            return this.grantType;
        }
    }
}

