/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.policyapi;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.confluent.security.policyapi.ConfluentPolicy;
import io.confluent.security.policyapi.TrustPolicy;
import io.confluent.security.policyapi.cel.TrustPolicyCelParser;
import io.confluent.security.policyapi.exception.PolicyEngineException;
import java.util.Objects;
import org.projectnessie.cel.Env;
import org.projectnessie.cel.Program;

public final class PolicyRuleLoadingCache<T> {
    public static final long CAPACITY_DEFAULT = 1000L;
    private final LoadingCache<ConfluentPolicy<T>, Program> cache;

    public PolicyRuleLoadingCache(Env env) {
        this(1000L, env);
    }

    public PolicyRuleLoadingCache(long capacity, Env env) {
        this.cache = this.buildCache(capacity, env);
    }

    public Program get(ConfluentPolicy<T> policy) {
        try {
            return (Program)this.cache.get(Objects.requireNonNull(policy));
        }
        catch (Throwable t) {
            throw new PolicyEngineException(String.format("Unable to process request for policy %s", policy), t);
        }
    }

    private LoadingCache<ConfluentPolicy<T>, Program> buildCache(long capacity, final Env env) {
        CacheLoader cacheLoader = new CacheLoader<ConfluentPolicy<T>, Program>(this){
            final /* synthetic */ PolicyRuleLoadingCache this$0;
            {
                this.this$0 = this$0;
            }

            public Program load(ConfluentPolicy<T> policy) {
                return TrustPolicyCelParser.compilePolicy(env, ((TrustPolicy)policy).condition());
            }
        };
        return CacheBuilder.newBuilder().maximumSize(capacity).build(cacheLoader);
    }
}

