/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runner;

import io.cucumber.core.backend.StepDefinition;
import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.runner.AmbiguousPickleStepDefinitionsMatch;
import io.cucumber.core.runner.CoreHookDefinition;
import io.cucumber.core.runner.CoreStepDefinition;
import io.cucumber.core.runner.ExecutionMode;
import io.cucumber.core.runner.HookDefinitionMatch;
import io.cucumber.core.runner.HookTestStep;
import io.cucumber.core.runner.PickleStepDefinitionMatch;
import io.cucumber.core.runner.PickleStepTestStep;
import io.cucumber.core.runner.TestCaseState;
import io.cucumber.core.runner.UndefinedPickleStepDefinitionMatch;
import io.cucumber.messages.Convertor;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Group;
import io.cucumber.messages.types.StepMatchArgument;
import io.cucumber.messages.types.StepMatchArgumentsList;
import io.cucumber.messages.types.TestCaseFinished;
import io.cucumber.plugin.event.Argument;
import io.cucumber.plugin.event.Location;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestStep;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

final class TestCase
implements io.cucumber.plugin.event.TestCase {
    private final Pickle pickle;
    private final List<PickleStepTestStep> testSteps;
    private final ExecutionMode executionMode;
    private final List<HookTestStep> beforeHooks;
    private final List<HookTestStep> afterHooks;
    private final UUID id;

    TestCase(UUID id, List<PickleStepTestStep> testSteps, List<HookTestStep> beforeHooks, List<HookTestStep> afterHooks, Pickle pickle, boolean dryRun) {
        this.id = id;
        this.testSteps = testSteps;
        this.beforeHooks = beforeHooks;
        this.afterHooks = afterHooks;
        this.pickle = pickle;
        this.executionMode = dryRun ? ExecutionMode.DRY_RUN : ExecutionMode.RUN;
    }

    private static Group makeMessageGroup(io.cucumber.plugin.event.Group group) {
        long start;
        return new Group(group.getChildren().stream().map(TestCase::makeMessageGroup).collect(Collectors.toList()), (start = (long)group.getStart()) == -1L ? null : Long.valueOf(start), group.getValue());
    }

    void run(EventBus bus) {
        ExecutionMode nextExecutionMode = this.executionMode;
        this.emitTestCaseMessage(bus);
        Instant start = bus.getInstant();
        UUID executionId = bus.generateId();
        this.emitTestCaseStarted(bus, start, executionId);
        TestCaseState state = new TestCaseState(bus, executionId, this);
        for (HookTestStep before : this.beforeHooks) {
            nextExecutionMode = before.run(this, bus, state, this.executionMode).next(nextExecutionMode);
        }
        for (PickleStepTestStep step : this.testSteps) {
            nextExecutionMode = step.run(this, bus, state, nextExecutionMode).next(nextExecutionMode);
        }
        for (HookTestStep after : this.afterHooks) {
            nextExecutionMode = after.run(this, bus, state, this.executionMode).next(nextExecutionMode);
        }
        Instant stop = bus.getInstant();
        Duration duration = Duration.between(start, stop);
        Status status = Status.valueOf((String)state.getStatus().name());
        Result result = new Result(status, duration, state.getError());
        this.emitTestCaseFinished(bus, executionId, stop, result);
    }

    public Integer getLine() {
        return this.pickle.getLocation().getLine();
    }

    public Location getLocation() {
        return this.pickle.getLocation();
    }

    public String getKeyword() {
        return this.pickle.getKeyword();
    }

    public String getName() {
        return this.pickle.getName();
    }

    public String getScenarioDesignation() {
        return this.fileColonLine(this.getLocation().getLine()) + " # " + this.getName();
    }

    private String fileColonLine(Integer line) {
        return this.pickle.getUri().getSchemeSpecificPart() + ":" + line;
    }

    public List<String> getTags() {
        return this.pickle.getTags();
    }

    public List<TestStep> getTestSteps() {
        ArrayList<TestStep> testSteps = new ArrayList<TestStep>(this.beforeHooks);
        for (PickleStepTestStep step : this.testSteps) {
            testSteps.addAll(step.getBeforeStepHookSteps());
            testSteps.add(step);
            testSteps.addAll(step.getAfterStepHookSteps());
        }
        testSteps.addAll(this.afterHooks);
        return testSteps;
    }

    public URI getUri() {
        return this.pickle.getUri();
    }

    public UUID getId() {
        return this.id;
    }

    private void emitTestCaseMessage(EventBus bus) {
        Envelope envelope = Envelope.of((io.cucumber.messages.types.TestCase)new io.cucumber.messages.types.TestCase(this.id.toString(), this.pickle.getId(), this.getTestSteps().stream().map(this::createTestStep).collect(Collectors.toList()), null));
        bus.send(envelope);
    }

    private io.cucumber.messages.types.TestStep createTestStep(TestStep pluginTestStep) {
        String id = pluginTestStep.getId().toString();
        String hookId = null;
        String pickleStepId = null;
        List<Object> stepMatchArgumentsLists = Collections.emptyList();
        List<Object> stepDefinitionIds = Collections.emptyList();
        if (pluginTestStep instanceof HookTestStep) {
            HookTestStep hookTestStep = (HookTestStep)pluginTestStep;
            HookDefinitionMatch definitionMatch = hookTestStep.getDefinitionMatch();
            CoreHookDefinition hookDefinition = definitionMatch.getHookDefinition();
            hookId = hookDefinition.getId().toString();
        } else if (pluginTestStep instanceof PickleStepTestStep) {
            PickleStepTestStep pickleStep = (PickleStepTestStep)pluginTestStep;
            pickleStepId = pickleStep.getStep().getId();
            stepMatchArgumentsLists = this.getStepMatchArguments(pickleStep);
            StepDefinition stepDefinition = pickleStep.getDefinitionMatch().getStepDefinition();
            if (stepDefinition instanceof CoreStepDefinition) {
                CoreStepDefinition coreStepDefinition = (CoreStepDefinition)stepDefinition;
                stepDefinitionIds = Collections.singletonList(coreStepDefinition.getId().toString());
            }
        }
        return new io.cucumber.messages.types.TestStep(hookId, id, pickleStepId, stepDefinitionIds, stepMatchArgumentsLists);
    }

    public List<StepMatchArgumentsList> getStepMatchArguments(PickleStepTestStep pickleStep) {
        PickleStepDefinitionMatch definitionMatch = pickleStep.getDefinitionMatch();
        if (definitionMatch instanceof UndefinedPickleStepDefinitionMatch) {
            return Collections.emptyList();
        }
        if (definitionMatch instanceof AmbiguousPickleStepDefinitionsMatch) {
            AmbiguousPickleStepDefinitionsMatch ambiguousPickleStepDefinitionsMatch = (AmbiguousPickleStepDefinitionsMatch)definitionMatch;
            return ambiguousPickleStepDefinitionsMatch.getDefinitionArguments().stream().map(TestCase::createStepMatchArgumentList).collect(Collectors.toList());
        }
        return Collections.singletonList(TestCase.createStepMatchArgumentList(pickleStep.getDefinitionArgument()));
    }

    private static StepMatchArgumentsList createStepMatchArgumentList(List<Argument> arguments) {
        return arguments.stream().map(arg -> new StepMatchArgument(TestCase.makeMessageGroup(arg.getGroup()), arg.getParameterTypeName())).collect(Collectors.collectingAndThen(Collectors.toList(), StepMatchArgumentsList::new));
    }

    private void emitTestCaseStarted(EventBus bus, Instant start, UUID executionId) {
        bus.send(new TestCaseStarted(start, (io.cucumber.plugin.event.TestCase)this));
        Envelope envelope = Envelope.of((io.cucumber.messages.types.TestCaseStarted)new io.cucumber.messages.types.TestCaseStarted(Long.valueOf(0L), executionId.toString(), this.id.toString(), Thread.currentThread().getName(), Convertor.toMessage((Instant)start)));
        bus.send(envelope);
    }

    private void emitTestCaseFinished(EventBus bus, UUID executionId, Instant stop, Result result) {
        bus.send(new io.cucumber.plugin.event.TestCaseFinished(stop, (io.cucumber.plugin.event.TestCase)this, result));
        Envelope envelope = Envelope.of((TestCaseFinished)new TestCaseFinished(executionId.toString(), Convertor.toMessage((Instant)stop), Boolean.valueOf(false)));
        bus.send(envelope);
    }
}

