/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.messages.types.StepKeywordType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;

public final class GherkinDialect {
    private static final Comparator<String> LONGEST_TO_SHORTEST_COMPARATOR = (a, b) -> Integer.compare(b.length(), a.length());
    private final String language;
    private final String name;
    private final String nativeName;
    private final List<String> featureKeywords;
    private final List<String> ruleKeywords;
    private final List<String> scenarioKeywords;
    private final List<String> scenarioOutlineKeywords;
    private final List<String> backgroundKeywords;
    private final List<String> examplesKeywords;
    private final List<String> givenKeywords;
    private final List<String> whenKeywords;
    private final List<String> thenKeywords;
    private final List<String> andKeywords;
    private final List<String> butKeywords;
    private final List<String> stepKeywords;
    private final Map<String, Set<StepKeywordType>> stepKeywordsTypes;

    GherkinDialect(String language, String name, String nativeName, List<String> featureKeywords, List<String> ruleKeywords, List<String> scenarioKeywords, List<String> scenarioOutlineKeywords, List<String> backgroundKeywords, List<String> examplesKeywords, List<String> givenKeywords, List<String> whenKeywords, List<String> thenKeywords, List<String> andKeywords, List<String> butKeywords) {
        this.language = Objects.requireNonNull(language);
        this.name = Objects.requireNonNull(name);
        this.nativeName = Objects.requireNonNull(nativeName);
        this.featureKeywords = Objects.requireNonNull(featureKeywords);
        this.ruleKeywords = Objects.requireNonNull(ruleKeywords);
        this.scenarioKeywords = Objects.requireNonNull(scenarioKeywords);
        this.scenarioOutlineKeywords = Objects.requireNonNull(scenarioOutlineKeywords);
        this.backgroundKeywords = Objects.requireNonNull(backgroundKeywords);
        this.examplesKeywords = Objects.requireNonNull(examplesKeywords);
        this.givenKeywords = Objects.requireNonNull(givenKeywords);
        this.whenKeywords = Objects.requireNonNull(whenKeywords);
        this.thenKeywords = Objects.requireNonNull(thenKeywords);
        this.andKeywords = Objects.requireNonNull(andKeywords);
        this.butKeywords = Objects.requireNonNull(butKeywords);
        this.stepKeywords = GherkinDialect.distinctKeywords(givenKeywords, whenKeywords, thenKeywords, andKeywords, butKeywords);
        this.stepKeywordsTypes = GherkinDialect.aggregateKeywordTypes(givenKeywords, whenKeywords, thenKeywords, andKeywords, butKeywords);
    }

    @SafeVarargs
    private static List<String> distinctKeywords(List<String> ... keywords) {
        HashSet<String> uniqueKeywords = new HashSet<String>(32);
        for (List<String> keyword : keywords) {
            uniqueKeywords.addAll(keyword);
        }
        ArrayList<String> sortedKeywords = new ArrayList<String>(uniqueKeywords);
        sortedKeywords.sort(LONGEST_TO_SHORTEST_COMPARATOR);
        return List.copyOf(sortedKeywords);
    }

    private static Map<String, Set<StepKeywordType>> aggregateKeywordTypes(List<String> givenKeywords, List<String> whenKeywords, List<String> thenKeywords, List<String> andKeywords, List<String> butKeywords) {
        HashMap<String, Set<StepKeywordType>> stepKeywordsTypes = new HashMap<String, Set<StepKeywordType>>();
        GherkinDialect.addStepKeywordsTypes(stepKeywordsTypes, StepKeywordType.CONTEXT, givenKeywords);
        GherkinDialect.addStepKeywordsTypes(stepKeywordsTypes, StepKeywordType.ACTION, whenKeywords);
        GherkinDialect.addStepKeywordsTypes(stepKeywordsTypes, StepKeywordType.OUTCOME, thenKeywords);
        GherkinDialect.addStepKeywordsTypes(stepKeywordsTypes, StepKeywordType.CONJUNCTION, GherkinDialect.distinctKeywords(andKeywords, butKeywords));
        stepKeywordsTypes.replaceAll((keyword, stepKeywordTypes) -> Set.copyOf(stepKeywordTypes));
        return stepKeywordsTypes;
    }

    private static void addStepKeywordsTypes(Map<String, Set<StepKeywordType>> accumulator, StepKeywordType type, List<String> keywords) {
        for (String keyword : keywords) {
            Set<StepKeywordType> stepKeywordTypes = accumulator.get(keyword);
            if (stepKeywordTypes == null) {
                accumulator.put(keyword, EnumSet.of(type));
                continue;
            }
            stepKeywordTypes.add(type);
        }
    }

    public List<String> getFeatureKeywords() {
        return this.featureKeywords;
    }

    public String getName() {
        return this.name;
    }

    public String getNativeName() {
        return this.nativeName;
    }

    public List<String> getRuleKeywords() {
        return this.ruleKeywords;
    }

    public List<String> getScenarioKeywords() {
        return this.scenarioKeywords;
    }

    public List<String> getScenarioOutlineKeywords() {
        return this.scenarioOutlineKeywords;
    }

    public List<String> getStepKeywords() {
        return this.stepKeywords;
    }

    @Deprecated
    public @Nullable List<StepKeywordType> getStepKeywordTypes(String keyword) {
        Set<StepKeywordType> stepKeywordTypes = this.stepKeywordsTypes.get(keyword);
        if (stepKeywordTypes == null) {
            return null;
        }
        return new ArrayList<StepKeywordType>(stepKeywordTypes);
    }

    public Set<StepKeywordType> getStepKeywordTypesSet(String keyword) {
        Objects.requireNonNull(keyword);
        Set<StepKeywordType> stepKeywordTypes = this.stepKeywordsTypes.get(keyword);
        if (stepKeywordTypes == null) {
            throw new NoSuchElementException("'%s' is not part of this dialect".formatted(keyword));
        }
        return stepKeywordTypes;
    }

    public List<String> getBackgroundKeywords() {
        return this.backgroundKeywords;
    }

    public List<String> getExamplesKeywords() {
        return this.examplesKeywords;
    }

    public List<String> getGivenKeywords() {
        return this.givenKeywords;
    }

    public List<String> getWhenKeywords() {
        return this.whenKeywords;
    }

    public List<String> getThenKeywords() {
        return this.thenKeywords;
    }

    public List<String> getAndKeywords() {
        return this.andKeywords;
    }

    public List<String> getButKeywords() {
        return this.butKeywords;
    }

    public String getLanguage() {
        return this.language;
    }
}

