/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.AstNode;
import io.cucumber.gherkin.LineSpan;
import io.cucumber.gherkin.Locations;
import io.cucumber.gherkin.Parser;
import io.cucumber.gherkin.ParserException;
import io.cucumber.gherkin.Token;
import io.cucumber.messages.IdGenerator;
import io.cucumber.messages.types.Background;
import io.cucumber.messages.types.Comment;
import io.cucumber.messages.types.DataTable;
import io.cucumber.messages.types.DocString;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.FeatureChild;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.RuleChild;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.TableCell;
import io.cucumber.messages.types.TableRow;
import io.cucumber.messages.types.Tag;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Objects;

final class GherkinDocumentBuilder
implements Parser.Builder<GherkinDocument> {
    private final List<Comment> comments = new ArrayList<Comment>();
    private final IdGenerator idGenerator;
    private String uri;
    private Deque<AstNode> stack;

    GherkinDocumentBuilder(IdGenerator idGenerator, String uri) {
        this.idGenerator = idGenerator;
        this.reset(uri);
    }

    @Override
    public void reset(String uri) {
        this.uri = uri;
        this.stack = new ArrayDeque<AstNode>();
        this.stack.push(new AstNode(Parser.RuleType.None));
    }

    private AstNode requiredCurrentNode() {
        return Objects.requireNonNull(this.stack.peek());
    }

    @Override
    public void build(Token token) {
        if (token.matchedType == Parser.TokenType.Comment) {
            Comment comment = new Comment(token.location, token.getRequiredMatchedText());
            this.comments.add(comment);
        } else {
            this.requiredCurrentNode().add(token.getRequiredMatchedType().ruleType, token);
        }
    }

    @Override
    public void startRule(Parser.RuleType ruleType) {
        this.stack.push(new AstNode(ruleType));
    }

    @Override
    public void endRule(Parser.RuleType ruleType) {
        AstNode node = this.stack.pop();
        Object transformedNode = this.getTransformedNode(node);
        this.requiredCurrentNode().add(node.ruleType, transformedNode);
    }

    private Object getTransformedNode(AstNode node) {
        return switch (node.ruleType) {
            case Parser.RuleType.Step -> {
                Token stepLine = node.getToken(Parser.TokenType.StepLine);
                yield new Step(stepLine.location, stepLine.getRequiredMatchedKeyword(), stepLine.keywordType, stepLine.getRequiredMatchedText(), (DocString)node.getSingle(Parser.RuleType.DocString), (DataTable)node.getSingle(Parser.RuleType.DataTable), this.idGenerator.newId());
            }
            case Parser.RuleType.DocString -> {
                Token separatorToken = node.getTokens(Parser.TokenType.DocStringSeparator).get(0);
                String matchedText = separatorToken.getRequiredMatchedText();
                String mediaType = matchedText.isEmpty() ? null : matchedText;
                List<Token> lineTokens = node.getTokens(Parser.TokenType.Other);
                String content = GherkinDocumentBuilder.joinMatchedText(lineTokens, lineTokens.size());
                yield new DocString(separatorToken.location, mediaType, content, separatorToken.getRequiredMatchedKeyword());
            }
            case Parser.RuleType.DataTable -> {
                List<TableRow> rows = this.getTableRows(node);
                yield new DataTable(rows.get(0).getLocation(), rows);
            }
            case Parser.RuleType.Background -> {
                Token backgroundLine = node.getToken(Parser.TokenType.BackgroundLine);
                yield new Background(backgroundLine.location, backgroundLine.getRequiredMatchedKeyword(), backgroundLine.getRequiredMatchedText(), this.getDescription(node), this.getSteps(node), this.idGenerator.newId());
            }
            case Parser.RuleType.ScenarioDefinition -> {
                AstNode scenarioNode = (AstNode)node.getRequiredSingle(Parser.RuleType.Scenario);
                Token scenarioLine = scenarioNode.getToken(Parser.TokenType.ScenarioLine);
                yield new Scenario(scenarioLine.location, this.getTags(node), scenarioLine.getRequiredMatchedKeyword(), scenarioLine.getRequiredMatchedText(), this.getDescription(scenarioNode), this.getSteps(scenarioNode), scenarioNode.getItems(Parser.RuleType.ExamplesDefinition), this.idGenerator.newId());
            }
            case Parser.RuleType.ExamplesDefinition -> {
                List<Object> tableBody;
                TableRow tableHeader;
                AstNode examplesNode = (AstNode)node.getRequiredSingle(Parser.RuleType.Examples);
                Token examplesLine = examplesNode.getToken(Parser.TokenType.ExamplesLine);
                List rows = (List)examplesNode.getSingle(Parser.RuleType.ExamplesTable);
                if (rows != null && !rows.isEmpty()) {
                    tableHeader = (TableRow)rows.get(0);
                    tableBody = rows.subList(1, rows.size());
                } else {
                    tableHeader = null;
                    tableBody = Collections.emptyList();
                }
                yield new Examples(examplesLine.location, this.getTags(node), examplesLine.getRequiredMatchedKeyword(), examplesLine.getRequiredMatchedText(), this.getDescription(examplesNode), tableHeader, tableBody, this.idGenerator.newId());
            }
            case Parser.RuleType.ExamplesTable -> this.getTableRows(node);
            case Parser.RuleType.Description -> {
                int toIndex;
                List<Token> lineTokens = node.getTokens(Parser.TokenType.Other);
                for (toIndex = lineTokens.size(); toIndex > 0 && lineTokens.get(toIndex - 1).getRequiredLine().isEmpty(); --toIndex) {
                }
                yield GherkinDocumentBuilder.joinMatchedText(lineTokens, toIndex);
            }
            case Parser.RuleType.Feature -> {
                AstNode header = (AstNode)node.getRequiredSingle(Parser.RuleType.FeatureHeader);
                List<Tag> tags = this.getTags(header);
                Token featureLine = header.getToken(Parser.TokenType.FeatureLine);
                ArrayList<FeatureChild> children = new ArrayList<FeatureChild>();
                Background background = (Background)node.getSingle(Parser.RuleType.Background);
                if (background != null) {
                    children.add(new FeatureChild(null, background, null));
                }
                for (Scenario scenario : node.getItems(Parser.RuleType.ScenarioDefinition)) {
                    children.add(new FeatureChild(null, null, scenario));
                }
                for (Rule rule : node.getItems(Parser.RuleType.Rule)) {
                    children.add(new FeatureChild(rule, null, null));
                }
                yield new Feature(featureLine.location, tags, featureLine.getRequiredMatchedLanguage(), featureLine.getRequiredMatchedKeyword(), featureLine.getRequiredMatchedText(), this.getDescription(header), children);
            }
            case Parser.RuleType.Rule -> {
                AstNode header = (AstNode)node.getRequiredSingle(Parser.RuleType.RuleHeader);
                Token ruleLine = header.getToken(Parser.TokenType.RuleLine);
                ArrayList<RuleChild> children = new ArrayList<RuleChild>();
                List<Tag> tags = this.getTags(header);
                Background background = (Background)node.getSingle(Parser.RuleType.Background);
                if (background != null) {
                    children.add(new RuleChild(background, null));
                }
                List scenarios = node.getItems(Parser.RuleType.ScenarioDefinition);
                for (Scenario scenario : scenarios) {
                    children.add(new RuleChild(null, scenario));
                }
                yield new Rule(ruleLine.location, tags, ruleLine.getRequiredMatchedKeyword(), ruleLine.getRequiredMatchedText(), this.getDescription(header), children, this.idGenerator.newId());
            }
            case Parser.RuleType.GherkinDocument -> {
                Feature feature = (Feature)node.getSingle(Parser.RuleType.Feature);
                yield new GherkinDocument(this.uri, feature, this.comments);
            }
            default -> node;
        };
    }

    private static String joinMatchedText(List<Token> lineTokens, int toIndex) {
        StringBuilder content = new StringBuilder(100 * lineTokens.size());
        for (int i = 0; i < toIndex; ++i) {
            Token lineToken = lineTokens.get(i);
            String matchedText = lineToken.getRequiredMatchedText();
            content.append(matchedText).append('\n');
        }
        int contentLength = content.length();
        if (contentLength > 0) {
            content.setLength(contentLength - 1);
        }
        return content.toString();
    }

    private List<TableRow> getTableRows(AstNode node) {
        List<Token> tokens = node.getTokens(Parser.TokenType.TableRow);
        int tokenSize = tokens.size();
        ArrayList<TableRow> rows = new ArrayList<TableRow>(tokenSize);
        for (int i = 0; i < tokenSize; ++i) {
            Token token = tokens.get(i);
            rows.add(new TableRow(token.location, this.getCells(token), this.idGenerator.newId()));
        }
        this.ensureCellCount(rows);
        return rows;
    }

    private void ensureCellCount(List<TableRow> rows) {
        if (rows.isEmpty()) {
            return;
        }
        int firstRowCellsSize = rows.get(0).getCells().size();
        int rowsSize = rows.size();
        for (int i = 0; i < rowsSize; ++i) {
            TableRow row = rows.get(i);
            if (row.getCells().size() == firstRowCellsSize) continue;
            throw new ParserException.AstBuilderException("inconsistent cell count within the table", row.getLocation());
        }
    }

    private List<TableCell> getCells(Token token) {
        List<LineSpan> matchedItems = token.matchedItems;
        if (matchedItems == null) {
            return new ArrayList<TableCell>(0);
        }
        int itemSize = matchedItems.size();
        ArrayList<TableCell> cells = new ArrayList<TableCell>(itemSize);
        for (int i = 0; i < itemSize; ++i) {
            LineSpan cellItem = matchedItems.get(i);
            TableCell tableCell = new TableCell(Locations.atColumn(token.location, cellItem.column), cellItem.text);
            cells.add(tableCell);
        }
        return cells;
    }

    private List<Step> getSteps(AstNode node) {
        return node.getItems(Parser.RuleType.Step);
    }

    private String getDescription(AstNode node) {
        return node.getSingle(Parser.RuleType.Description, "");
    }

    private List<Tag> getTags(AstNode node) {
        AstNode tagsNode = (AstNode)node.getSingle(Parser.RuleType.Tags);
        if (tagsNode == null) {
            return new ArrayList<Tag>(0);
        }
        List<Token> tokens = tagsNode.getTokens(Parser.TokenType.TagLine);
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (Token token : tokens) {
            List<LineSpan> matchedItems = token.matchedItems;
            if (matchedItems == null) continue;
            for (LineSpan tagItem : matchedItems) {
                tags.add(new Tag(Locations.atColumn(token.location, tagItem.column), tagItem.text, this.idGenerator.newId()));
            }
        }
        return tags;
    }

    @Override
    public GherkinDocument getResult() {
        return (GherkinDocument)this.requiredCurrentNode().getRequiredSingle(Parser.RuleType.GherkinDocument);
    }
}

