/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.Locations;
import io.cucumber.gherkin.Token;
import io.cucumber.messages.types.Location;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

class ParserException
extends RuntimeException {
    final @Nullable Location location;

    protected ParserException(String message) {
        super(message);
        this.location = null;
    }

    protected ParserException(String message, @Nullable Location location) {
        super(ParserException.createMessage(message, location));
        this.location = location;
    }

    private static String createMessage(String message, @Nullable Location location) {
        if (location == null) {
            return "(-1,0): %s".formatted(message);
        }
        Integer line = location.getLine();
        Integer column = location.getColumn().orElse(0);
        return "(%s:%s): %s".formatted(line, column, message);
    }

    static final class CompositeParserException
    extends ParserException {
        final List<ParserException> errors;

        CompositeParserException(List<ParserException> errors) {
            super(CompositeParserException.getMessage(errors));
            this.errors = List.copyOf(errors);
        }

        private static String getMessage(List<ParserException> errors) {
            return "Parser errors:\n" + errors.stream().map(Throwable::getMessage).collect(Collectors.joining("\n"));
        }
    }

    static final class UnexpectedEOFException
    extends ParserException {
        final String stateComment;
        final List<String> expectedTokenTypes;

        UnexpectedEOFException(Token receivedToken, List<String> expectedTokenTypes, String stateComment) {
            super(UnexpectedEOFException.getMessage(expectedTokenTypes), receivedToken.location);
            this.expectedTokenTypes = expectedTokenTypes;
            this.stateComment = stateComment;
        }

        private static String getMessage(List<String> expectedTokenTypes) {
            return "unexpected end of file, expected: %s".formatted(String.join((CharSequence)", ", expectedTokenTypes));
        }
    }

    static final class UnexpectedTokenException
    extends ParserException {
        final Token receivedToken;
        final List<String> expectedTokenTypes;
        final String stateComment;

        UnexpectedTokenException(Token receivedToken, List<String> expectedTokenTypes, String stateComment) {
            super(UnexpectedTokenException.getMessage(receivedToken, expectedTokenTypes), UnexpectedTokenException.getLocation(receivedToken));
            this.receivedToken = receivedToken;
            this.expectedTokenTypes = expectedTokenTypes;
            this.stateComment = stateComment;
        }

        private static String getMessage(Token receivedToken, List<String> expectedTokenTypes) {
            return "expected: %s, got '%s'".formatted(String.join((CharSequence)", ", expectedTokenTypes), receivedToken.getTokenValue());
        }

        private static Location getLocation(Token receivedToken) {
            if (receivedToken.location.getColumn().isPresent()) {
                return receivedToken.location;
            }
            int column = 1 + Objects.requireNonNull(receivedToken.line).getIndent();
            return Locations.atColumn(receivedToken.location, column);
        }
    }

    static final class NoSuchLanguageException
    extends ParserException {
        NoSuchLanguageException(String language, @Nullable Location location) {
            super("Language not supported: " + language, location);
        }
    }

    static final class AstBuilderException
    extends ParserException {
        AstBuilderException(String message, Location location) {
            super(message, location);
        }
    }
}

