/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.LineSpan;
import io.cucumber.gherkin.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.PrimitiveIterator;

final class TableRowLine {
    private TableRowLine() {
    }

    static List<LineSpan> parse(int indent, String text) {
        ArrayList<LineSpan> lineSpans = new ArrayList<LineSpan>();
        StringBuilder cellBuilder = new StringBuilder();
        boolean beforeFirst = true;
        int col = 0;
        int cellStart = 0;
        boolean escape = false;
        PrimitiveIterator.OfInt iterator = text.codePoints().iterator();
        while (iterator.hasNext()) {
            int c = iterator.next();
            if (escape) {
                switch (c) {
                    case 110: {
                        cellBuilder.append('\n');
                        break;
                    }
                    case 92: {
                        cellBuilder.append('\\');
                        break;
                    }
                    case 124: {
                        cellBuilder.append('|');
                        break;
                    }
                    default: {
                        cellBuilder.append("\\").appendCodePoint(c);
                    }
                }
                escape = false;
            } else if (c == 92) {
                escape = true;
            } else if (c == 124) {
                if (beforeFirst) {
                    beforeFirst = false;
                } else {
                    StringUtils.IndentedText trimmedCellIndent = StringUtils.trimAndIndentKeepNewLines(cellBuilder);
                    int column = indent + cellStart + trimmedCellIndent.getIndent() + 1;
                    lineSpans.add(new LineSpan(column, trimmedCellIndent.getText()));
                }
                cellBuilder.setLength(0);
                cellStart = col + 1;
            } else {
                cellBuilder.appendCodePoint(c);
            }
            ++col;
        }
        return lineSpans;
    }
}

