/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages;

import io.cucumber.messages.types.Envelope;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class NdjsonToMessageReader
implements AutoCloseable {
    private final BufferedReader reader;
    private final Deserializer deserializer;

    public NdjsonToMessageReader(InputStream inputStream, Deserializer deserializer) {
        this(NdjsonToMessageReader.createBufferedInputStreamReader(inputStream), Objects.requireNonNull(deserializer));
    }

    private static BufferedReader createBufferedInputStreamReader(InputStream inputStream) {
        Objects.requireNonNull(inputStream);
        return new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
    }

    private NdjsonToMessageReader(BufferedReader reader, Deserializer deserializer) {
        this.reader = reader;
        this.deserializer = deserializer;
    }

    public Envelope readLine() throws IOException {
        String json = this.reader.readLine();
        if (json == null) {
            return null;
        }
        Envelope envelope = this.deserializer.readValue(json);
        if (envelope == null) {
            throw new IOException("inputStream may not contain 'null' values");
        }
        return envelope;
    }

    public Stream<Envelope> lines() {
        Iterator<Envelope> iterator = new Iterator<Envelope>(){
            private Envelope next;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                try {
                    this.next = NdjsonToMessageReader.this.readLine();
                    return this.next != null;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public Envelope next() {
                if (this.next != null || this.hasNext()) {
                    Envelope envelope = this.next;
                    this.next = null;
                    return envelope;
                }
                throw new NoSuchElementException();
            }
        };
        Spliterator<Envelope> spliterator = Spliterators.spliteratorUnknownSize(iterator, 272);
        return StreamSupport.stream(spliterator, false);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @FunctionalInterface
    public static interface Deserializer {
        public Envelope readValue(String var1) throws IOException;
    }
}

