/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.Comment;
import io.cucumber.messages.types.Feature;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public final class GherkinDocument {
    private final @Nullable String uri;
    private final @Nullable Feature feature;
    private final List<Comment> comments;

    public GherkinDocument(@Nullable String uri, @Nullable Feature feature, List<Comment> comments) {
        this.uri = uri;
        this.feature = feature;
        this.comments = List.copyOf((Collection)Objects.requireNonNull(comments, "GherkinDocument.comments cannot be null"));
    }

    public Optional<String> getUri() {
        return Optional.ofNullable(this.uri);
    }

    public Optional<Feature> getFeature() {
        return Optional.ofNullable(this.feature);
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GherkinDocument that = (GherkinDocument)o;
        return Objects.equals(this.uri, that.uri) && Objects.equals(this.feature, that.feature) && this.comments.equals(that.comments);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.feature, this.comments);
    }

    public String toString() {
        return "GherkinDocument{uri=" + this.uri + ", feature=" + String.valueOf(this.feature) + ", comments=" + String.valueOf(this.comments) + "}";
    }
}

