/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.Timestamp;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public final class TestRunStarted {
    private final Timestamp timestamp;
    private final @Nullable String id;

    public TestRunStarted(Timestamp timestamp, @Nullable String id) {
        this.timestamp = Objects.requireNonNull(timestamp, "TestRunStarted.timestamp cannot be null");
        this.id = id;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public Optional<String> getId() {
        return Optional.ofNullable(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestRunStarted that = (TestRunStarted)o;
        return this.timestamp.equals(that.timestamp) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.id);
    }

    public String toString() {
        return "TestRunStarted{timestamp=" + String.valueOf(this.timestamp) + ", id=" + this.id + "}";
    }
}

