/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.Duration;
import io.cucumber.messages.types.Exception;
import io.cucumber.messages.types.TestStepResultStatus;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public final class TestStepResult {
    private final Duration duration;
    private final @Nullable String message;
    private final TestStepResultStatus status;
    private final @Nullable Exception exception;

    public TestStepResult(Duration duration, @Nullable String message, TestStepResultStatus status, @Nullable Exception exception) {
        this.duration = Objects.requireNonNull(duration, "TestStepResult.duration cannot be null");
        this.message = message;
        this.status = Objects.requireNonNull(status, "TestStepResult.status cannot be null");
        this.exception = exception;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    public TestStepResultStatus getStatus() {
        return this.status;
    }

    public Optional<Exception> getException() {
        return Optional.ofNullable(this.exception);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestStepResult that = (TestStepResult)o;
        return this.duration.equals(that.duration) && Objects.equals(this.message, that.message) && this.status.equals((Object)that.status) && Objects.equals(this.exception, that.exception);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.duration, this.message, this.status, this.exception});
    }

    public String toString() {
        return "TestStepResult{duration=" + String.valueOf(this.duration) + ", message=" + this.message + ", status=" + String.valueOf((Object)this.status) + ", exception=" + String.valueOf(this.exception) + "}";
    }
}

