/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import io.dropwizard.jdbi.args.OffsetDateTimeArgument;
import java.time.OffsetDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.TimeZone;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

public class OffsetDateTimeArgumentFactory
implements ArgumentFactory<OffsetDateTime> {
    private final Optional<Calendar> calendar;

    public OffsetDateTimeArgumentFactory() {
        this.calendar = Optional.empty();
    }

    public OffsetDateTimeArgumentFactory(Optional<TimeZone> timeZone) {
        this.calendar = timeZone.map(GregorianCalendar::new);
    }

    public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
        return value instanceof OffsetDateTime;
    }

    public Argument build(Class<?> expectedType, OffsetDateTime value, StatementContext ctx) {
        return new OffsetDateTimeArgument(value, this.calendar);
    }
}

