/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.OptionalDouble;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

public class OptionalDoubleArgumentFactory
implements ArgumentFactory<OptionalDouble> {
    public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
        return value instanceof OptionalDouble;
    }

    public Argument build(Class<?> expectedType, OptionalDouble value, StatementContext ctx) {
        return new DefaultOptionalArgument(value);
    }

    private static class DefaultOptionalArgument
    implements Argument {
        private final OptionalDouble value;

        private DefaultOptionalArgument(OptionalDouble value) {
            this.value = value;
        }

        public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
            if (this.value.isPresent()) {
                statement.setDouble(position, this.value.getAsDouble());
            } else {
                statement.setNull(position, 8);
            }
        }
    }
}

