/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import io.dropwizard.jdbi.args.InstantArgument;
import java.time.Instant;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.TimeZone;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

public class OptionalInstantArgumentFactory
implements ArgumentFactory<Optional<Instant>> {
    private final Optional<Calendar> calendar;

    public OptionalInstantArgumentFactory() {
        this.calendar = Optional.empty();
    }

    public OptionalInstantArgumentFactory(Optional<TimeZone> timeZone) {
        this.calendar = timeZone.map(GregorianCalendar::new);
    }

    public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
        if (value instanceof Optional) {
            Optional optionalValue = (Optional)value;
            return optionalValue.isPresent() && optionalValue.get() instanceof Instant;
        }
        return false;
    }

    public Argument build(Class<?> expectedType, Optional<Instant> value, StatementContext ctx) {
        return new InstantArgument(value.get(), this.calendar);
    }
}

