/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Triggerable;
import io.fabric8.kubernetes.client.dsl.Typeable;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.DoneableBuildConfig;
import io.fabric8.openshift.api.model.WebHookTrigger;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.BuildConfigOperation;
import io.fabric8.openshift.client.dsl.ClientBuildConfigResource;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;
import java.io.InputStream;
import java.net.URL;

public class BuildConfigOperationsImpl
extends OpenShiftOperation<BuildConfig, BuildConfigList, DoneableBuildConfig, ClientBuildConfigResource<BuildConfig, DoneableBuildConfig, Void, Void>>
implements BuildConfigOperation {
    private final String secret;
    private final String triggerType;

    public BuildConfigOperationsImpl(OkHttpClient client, OpenShiftConfig config, String namespace) {
        this(client, config, null, namespace, null, true, null, null, false, null, null);
    }

    public BuildConfigOperationsImpl(OkHttpClient client, OpenShiftConfig config, String apiVersion, String namespace, String name, Boolean cascading, BuildConfig item, String resourceVersion, Boolean reloadingFromServer, String secret, String triggerType) {
        super(client, config, (String)null, apiVersion, "buildconfigs", namespace, name, cascading, item, resourceVersion, reloadingFromServer);
        this.triggerType = triggerType;
        this.secret = secret;
    }

    @Override
    public ClientBuildConfigResource<BuildConfig, DoneableBuildConfig, Void, Void> withName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name must be provided.");
        }
        return new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), name, this.isCascading(), (BuildConfig)this.getItem(), this.getResourceVersion(), this.getReloadingFromServer(), this.secret, this.triggerType);
    }

    @Override
    public OpenShiftOperation<BuildConfig, BuildConfigList, DoneableBuildConfig, ClientBuildConfigResource<BuildConfig, DoneableBuildConfig, Void, Void>> inNamespace(String namespace) {
        return new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), namespace, this.getName(), this.isCascading(), (BuildConfig)this.getItem(), this.getResourceVersion(), this.getReloadingFromServer(), this.secret, this.triggerType);
    }

    @Override
    public Gettable<BuildConfig> fromServer() {
        return new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.namespace, this.getName(), this.isCascading(), (BuildConfig)this.getItem(), this.getResourceVersion(), true, this.secret, this.triggerType);
    }

    public Typeable<Triggerable<WebHookTrigger, Void>> withSecret(String secret) {
        return new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (BuildConfig)this.getItem(), this.getResourceVersion(), this.getReloadingFromServer(), secret, this.triggerType);
    }

    @Override
    public ClientBuildConfigResource<BuildConfig, DoneableBuildConfig, Void, Void> load(InputStream is) {
        return new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (BuildConfig)BuildConfigOperationsImpl.unmarshal(is, this.getType()), this.getResourceVersion(), this.getReloadingFromServer(), this.secret, this.triggerType);
    }

    public Void instantiate(BuildRequest request) {
        try {
            URL instantiationUrl = new URL(URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), "instantiate"}));
            RequestBody requestBody = RequestBody.create((MediaType)JSON, (String)BaseOperation.JSON_MAPPER.writer().writeValueAsString((Object)request));
            Request.Builder requestBuilder = new Request.Builder().post(requestBody).url(instantiationUrl);
            this.handleResponse(requestBuilder, 201, null);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
        return null;
    }

    public Void trigger(WebHookTrigger trigger) {
        try {
            String triggerUrl = URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), "webhooks", this.secret, this.triggerType});
            RequestBody requestBody = RequestBody.create((MediaType)JSON, (String)BaseOperation.JSON_MAPPER.writer().writeValueAsString((Object)trigger));
            Request.Builder requestBuilder = new Request.Builder().post(requestBody).url(triggerUrl).addHeader("Content-Type", "application/json").addHeader("X-Github-Event", "push");
            this.handleResponse(requestBuilder, 200);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
        return null;
    }

    public Triggerable<WebHookTrigger, Void> withType(String type) {
        return new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (BuildConfig)this.getItem(), this.getResourceVersion(), this.getReloadingFromServer(), this.secret, type);
    }
}

