/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import com.squareup.okhttp.OkHttpClient;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.api.model.LocalSubjectAccessReview;
import io.fabric8.openshift.api.model.LocalSubjectAccessReviewBuilder;
import io.fabric8.openshift.api.model.LocalSubjectAccessReviewFluent;
import io.fabric8.openshift.api.model.SubjectAccessReview;
import io.fabric8.openshift.api.model.SubjectAccessReviewBuilder;
import io.fabric8.openshift.api.model.SubjectAccessReviewFluent;
import io.fabric8.openshift.api.model.SubjectAccessReviewResponse;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.ClientSubjectAccessReviewOperation;
import io.fabric8.openshift.client.dsl.CreateableLocalSubjectAccessReview;
import io.fabric8.openshift.client.dsl.CreateableSubjectAccessReview;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutionException;

public class ClientSubjectAccessReviewOperationImpl
extends OperationSupport
implements ClientSubjectAccessReviewOperation<CreateableSubjectAccessReview, CreateableLocalSubjectAccessReview> {
    public ClientSubjectAccessReviewOperationImpl(OkHttpClient client, OpenShiftConfig config) {
        this(client, config, null, null);
    }

    public ClientSubjectAccessReviewOperationImpl(OkHttpClient client, OpenShiftConfig config, String apiVersion, String namespace) {
        super(client, (Config)config, null, apiVersion, "subjectaccessreviews", namespace, null);
    }

    public CreateableLocalSubjectAccessReview inNamespace(String namespace) {
        return new ClientSubjectAccessReviewOperationImpl(this.client, OpenShiftConfig.wrap(this.getConfig()), null, namespace).local();
    }

    public SubjectAccessReviewResponse create(SubjectAccessReview ... item) {
        return new CreateableSubjectAccessReviewImpl(this.client).create(item);
    }

    public CreateableSubjectAccessReview createNew() {
        return new CreateableSubjectAccessReviewImpl(this.client).createNew();
    }

    public URL getRootUrl() {
        try {
            return new URL(OpenShiftConfig.wrap(this.getConfig()).getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    private CreateableLocalSubjectAccessReview local() {
        return new CreateableLocalSubjectAccessReviewImpl(this.client);
    }

    protected <T> String checkNamespace(T item) {
        String itemNs;
        String operationNs = this.getNamespace();
        String string = itemNs = item instanceof HasMetadata && ((HasMetadata)item).getMetadata() != null ? ((HasMetadata)item).getMetadata().getNamespace() : null;
        if (Utils.isNullOrEmpty((String)operationNs) && Utils.isNullOrEmpty(itemNs)) {
            return null;
        }
        if (Utils.isNullOrEmpty(itemNs)) {
            return operationNs;
        }
        if (Utils.isNullOrEmpty((String)operationNs)) {
            return itemNs;
        }
        if (itemNs.equals(operationNs)) {
            return itemNs;
        }
        throw new KubernetesClientException("Namespace mismatch. Item namespace:" + itemNs + ". Operation namespace:" + operationNs + ".");
    }

    private class CreateableSubjectAccessReviewImpl
    extends CreateableSubjectAccessReview {
        private final OkHttpClient client;
        private final SubjectAccessReviewBuilder builder;

        private CreateableSubjectAccessReviewImpl(OkHttpClient client) {
            this.client = client;
            this.builder = new SubjectAccessReviewBuilder((SubjectAccessReviewFluent)this);
        }

        private CreateableSubjectAccessReviewImpl(OkHttpClient client, SubjectAccessReviewBuilder builder) {
            this.client = client;
            this.builder = builder;
        }

        public SubjectAccessReviewResponse create(SubjectAccessReview ... resources) {
            try {
                if (resources.length > 1) {
                    throw new IllegalArgumentException("Too many items to create.");
                }
                if (resources.length == 1) {
                    return (SubjectAccessReviewResponse)ClientSubjectAccessReviewOperationImpl.this.handleCreate(resources[0], SubjectAccessReviewResponse.class);
                }
                throw new IllegalArgumentException("Nothing to create.");
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw KubernetesClientException.launderThrowable((Throwable)e);
            }
        }

        public CreateableSubjectAccessReview createNew() {
            return this;
        }

        public SubjectAccessReviewResponse done() {
            return this.create(new SubjectAccessReview[]{this.builder.build()});
        }
    }

    private class CreateableLocalSubjectAccessReviewImpl
    extends CreateableLocalSubjectAccessReview {
        private final OkHttpClient client;
        private final LocalSubjectAccessReviewBuilder builder;

        private CreateableLocalSubjectAccessReviewImpl(OkHttpClient client) {
            this.client = client;
            this.builder = new LocalSubjectAccessReviewBuilder((LocalSubjectAccessReviewFluent)this);
        }

        private CreateableLocalSubjectAccessReviewImpl(OkHttpClient client, LocalSubjectAccessReviewBuilder builder) {
            this.client = client;
            this.builder = builder;
        }

        public SubjectAccessReviewResponse create(LocalSubjectAccessReview ... resources) {
            try {
                if (resources.length > 1) {
                    throw new IllegalArgumentException("Too many items to create.");
                }
                if (resources.length == 1) {
                    return (SubjectAccessReviewResponse)ClientSubjectAccessReviewOperationImpl.this.handleCreate(resources[0], SubjectAccessReviewResponse.class);
                }
                throw new IllegalArgumentException("Nothing to create.");
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw KubernetesClientException.launderThrowable((Throwable)e);
            }
        }

        public CreateableLocalSubjectAccessReview createNew() {
            return this;
        }

        public SubjectAccessReviewResponse done() {
            return this.create(new LocalSubjectAccessReview[]{this.builder.build()});
        }
    }
}

