/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.report;

import io.gatling.charts.component.AssertionsTableComponent;
import io.gatling.charts.component.Component;
import io.gatling.charts.component.ComponentLibrary;
import io.gatling.charts.component.ErrorsTableComponent;
import io.gatling.charts.component.GlobalStatsTableComponent;
import io.gatling.charts.component.SimulationCardComponent;
import io.gatling.charts.config.ChartsFiles;
import io.gatling.charts.report.ReportGenerator;
import io.gatling.charts.report.ReportsGenerationInputs;
import io.gatling.charts.report.SchemaContainerComponent;
import io.gatling.charts.report.TemplateWriter;
import io.gatling.charts.stats.CountsVsTimePlot;
import io.gatling.charts.stats.Group;
import io.gatling.charts.stats.IntVsTimePlot;
import io.gatling.charts.stats.PercentVsTimePlot;
import io.gatling.charts.stats.PieSlice;
import io.gatling.charts.stats.Series;
import io.gatling.charts.stats.Series$;
import io.gatling.charts.template.GlobalPageTemplate;
import io.gatling.charts.util.Color;
import io.gatling.charts.util.Color$Requests$;
import io.gatling.charts.util.Color$Users$;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.core.config.ReportsConfiguration;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.time.ZoneId;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005Q3Q!\u0003\u0006\u0001\u0019IA\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I!\u0007\u0005\t9\u0001\u0011\t\u0011)A\u0005;!A1\u0005\u0001B\u0001B\u0003%A\u0005\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0011!\u0019\u0004A!A!\u0002\u0013!\u0004\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\t\u000b\r\u0003A\u0011\u0001#\t\u000b1\u0003A\u0011A'\u0003+\u001dcwNY1m%\u0016\u0004xN\u001d;HK:,'/\u0019;pe*\u00111\u0002D\u0001\u0007e\u0016\u0004xN\u001d;\u000b\u00055q\u0011AB2iCJ$8O\u0003\u0002\u0010!\u00059q-\u0019;mS:<'\"A\t\u0002\u0005%|7C\u0001\u0001\u0014!\t!R#D\u0001\u000b\u0013\t1\"BA\bSKB|'\u000f^$f]\u0016\u0014\u0018\r^8s\u0003]\u0011X\r]8siN<UM\\3sCRLwN\\%oaV$8o\u0001\u0001\u0011\u0005QQ\u0012BA\u000e\u000b\u0005]\u0011V\r]8siN<UM\\3sCRLwN\\%oaV$8/A\u0006dQ\u0006\u0014Ho\u001d$jY\u0016\u001c\bC\u0001\u0010\"\u001b\u0005y\"B\u0001\u0011\r\u0003\u0019\u0019wN\u001c4jO&\u0011!e\b\u0002\f\u0007\"\f'\u000f^:GS2,7/\u0001\td_6\u0004xN\\3oi2K'M]1ssB\u0011Q\u0005K\u0007\u0002M)\u0011q\u0005D\u0001\nG>l\u0007o\u001c8f]RL!!\u000b\u0014\u0003!\r{W\u000e]8oK:$H*\u001b2sCJL\u0018A\u0002>p]\u0016LE\r\u0005\u0002-c5\tQF\u0003\u0002/_\u0005!A/[7f\u0015\u0005\u0001\u0014\u0001\u00026bm\u0006L!AM\u0017\u0003\ri{g.Z%e\u0003\u001d\u0019\u0007.\u0019:tKR\u0004\"!N\u001d\u000e\u0003YR!aM\u001c\u000b\u0005az\u0013a\u00018j_&\u0011!H\u000e\u0002\b\u0007\"\f'o]3u\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u0011Q(Q\u0007\u0002})\u0011\u0001e\u0010\u0006\u0003\u0001:\tAaY8sK&\u0011!I\u0010\u0002\u0015%\u0016\u0004xN\u001d;t\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\u001d)ei\u0012%J\u0015.\u0003\"\u0001\u0006\u0001\t\u000b]9\u0001\u0019A\r\t\u000bq9\u0001\u0019A\u000f\t\u000b\r:\u0001\u0019\u0001\u0013\t\u000b):\u0001\u0019A\u0016\t\u000bM:\u0001\u0019\u0001\u001b\t\u000bm:\u0001\u0019\u0001\u001f\u0002\u0011\u001d,g.\u001a:bi\u0016$\u0012A\u0014\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0002#\u0006)1oY1mC&\u00111\u000b\u0015\u0002\u0005+:LG\u000f")
public class GlobalReportGenerator
extends ReportGenerator {
    private final ReportsGenerationInputs reportsGenerationInputs;
    private final ChartsFiles chartsFiles;
    private final ComponentLibrary componentLibrary;
    private final ZoneId zoneId;
    private final Charset charset;
    private final ReportsConfiguration configuration;

    @Override
    public void generate() {
        GlobalPageTemplate template = new GlobalPageTemplate(this.reportsGenerationInputs.logFileData().runInfo(), (Seq<Component>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Component[]{new SchemaContainerComponent((Seq<Component>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Component[]{this.componentLibrary.getRangesComponent("Response Time Ranges", "requests", false), this.componentLibrary.getRequestCountPolarComponent(), new SimulationCardComponent(this.reportsGenerationInputs.logFileData().runInfo(), this.zoneId)})), new AssertionsTableComponent(this.reportsGenerationInputs.assertionResults()), new GlobalStatsTableComponent(this.configuration.indicators()), new ErrorsTableComponent(this.reportsGenerationInputs.logFileData().errors((Option<String>)None$.MODULE$, (Option<Group>)None$.MODULE$)), this.activeSessionsChartComponent$1(), this.responseTimeDistributionChartComponent$1(), this.responseTimeChartComponent$1(), this.requestsChartComponent$1(), this.responsesChartComponent$1()}));
        new TemplateWriter(this.chartsFiles.globalFile()).writeToFile(template.getOutput(), this.charset);
    }

    private final Component activeSessionsChartComponent$1() {
        List seriesColors = package$.MODULE$.Iterator().continually((Function0 & Serializable)() -> Color$Users$.MODULE$.Base()).flatten(Predef$.MODULE$.$conforms()).take(this.reportsGenerationInputs.logFileData().scenarioNames().size()).toList();
        List activeSessionsSeries = ((List)this.reportsGenerationInputs.logFileData().scenarioNames().map((Function1 & Serializable)scenarioName -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(scenarioName), $this.reportsGenerationInputs.logFileData().numberOfActiveSessionsPerSecond((Option<String>)new Some(scenarioName)))).reverse().zip((IterableOnce)seriesColors)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Color color = (Color)tuple2._2();
                if (tuple22 != null) {
                    String scenarioName = (String)tuple22._1();
                    Seq data = (Seq)tuple22._2();
                    return new Series(scenarioName, data, (List<Color>)new .colon.colon((Object)color, (List)Nil$.MODULE$));
                }
            }
            throw new MatchError((Object)tuple2);
        });
        return this.componentLibrary.getActiveSessionsComponent(this.reportsGenerationInputs.logFileData().runInfo().injectStart(), (Seq<Series<IntVsTimePlot>>)activeSessionsSeries);
    }

    private final Component responseTimeDistributionChartComponent$1() {
        Tuple2<Seq<PercentVsTimePlot>, Seq<PercentVsTimePlot>> tuple2 = this.reportsGenerationInputs.logFileData().responseTimeDistribution(100, (Option<String>)None$.MODULE$, (Option<Group>)None$.MODULE$);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq okDistribution = (Seq)tuple2._1();
        Seq koDistribution = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)okDistribution, (Object)koDistribution);
        Seq okDistribution2 = (Seq)tuple22._1();
        Seq koDistribution2 = (Seq)tuple22._2();
        Series<PercentVsTimePlot> okDistributionSeries = new Series<PercentVsTimePlot>(Series$.MODULE$.OK(), (Iterable<PercentVsTimePlot>)okDistribution2, (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.Ok(), (List)Nil$.MODULE$));
        Series<PercentVsTimePlot> koDistributionSeries = new Series<PercentVsTimePlot>(Series$.MODULE$.KO(), (Iterable<PercentVsTimePlot>)koDistribution2, (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.Ko(), (List)Nil$.MODULE$));
        return this.componentLibrary.getDistributionComponent("Response Time", "Requests", okDistributionSeries, koDistributionSeries);
    }

    private final Component responseTimeChartComponent$1() {
        return this.percentilesChartComponent$1((Function3 & Serializable)(status, requestName, group) -> $this.reportsGenerationInputs.logFileData().responseTimePercentilesOverTime((Status)status, (Option<String>)requestName, (Option<Group>)group), (Function2 & Serializable)(x$2, x$3) -> this.componentLibrary.getPercentilesOverTimeComponent("Response Time", BoxesRunTime.unboxToLong((Object)x$2), x$3), "Response Time Percentiles over Time");
    }

    private final Component percentilesChartComponent$1(Function3 dataSource, Function2 componentFactory, String title) {
        Iterable successData = (Iterable)dataSource.apply((Object)OK$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
        Series successSeries = new Series(title + " (" + Series$.MODULE$.OK() + ")", successData, Color$Requests$.MODULE$.Percentiles());
        return (Component)componentFactory.apply((Object)BoxesRunTime.boxToLong((long)this.reportsGenerationInputs.logFileData().runInfo().injectStart()), successSeries);
    }

    private final Component requestsChartComponent$1() {
        return this.countsChartComponent$1((Function2 & Serializable)(requestName, group) -> $this.reportsGenerationInputs.logFileData().numberOfRequestsPerSecond((Option<String>)requestName, (Option<Group>)group), (Function3 & Serializable)(runStart, counts, pieSeries) -> this.componentLibrary.getRequestsComponent(BoxesRunTime.unboxToLong((Object)runStart), counts, pieSeries));
    }

    private final Component responsesChartComponent$1() {
        return this.countsChartComponent$1((Function2 & Serializable)(requestName, group) -> $this.reportsGenerationInputs.logFileData().numberOfResponsesPerSecond((Option<String>)requestName, (Option<Group>)group), (Function3 & Serializable)(runStart, counts, pieSeries) -> this.componentLibrary.getResponsesComponent(BoxesRunTime.unboxToLong((Object)runStart), counts, pieSeries));
    }

    private final Component countsChartComponent$1(Function2 dataSource, Function3 componentFactory) {
        Seq counts = (Seq)((SeqOps)dataSource.apply((Object)None$.MODULE$, (Object)None$.MODULE$)).sortBy((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.time()), (Ordering)Ordering.Int$.MODULE$);
        Series countsSeries = new Series("", counts, (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.All(), (List)new .colon.colon((Object)Color$Requests$.MODULE$.Ok(), (List)new .colon.colon((Object)Color$Requests$.MODULE$.Ko(), (List)Nil$.MODULE$))));
        Series pieRequestsSeries = new Series(Series$.MODULE$.Distribution(), new .colon.colon((Object)new PieSlice(Series$.MODULE$.OK(), this.count((Seq<CountsVsTimePlot>)counts, (Status)OK$.MODULE$)), (List)new .colon.colon((Object)new PieSlice(Series$.MODULE$.KO(), this.count((Seq<CountsVsTimePlot>)counts, (Status)KO$.MODULE$)), (List)Nil$.MODULE$)), (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.Ok(), (List)new .colon.colon((Object)Color$Requests$.MODULE$.Ko(), (List)Nil$.MODULE$)));
        return (Component)componentFactory.apply((Object)BoxesRunTime.boxToLong((long)this.reportsGenerationInputs.logFileData().runInfo().injectStart()), countsSeries, pieRequestsSeries);
    }

    public GlobalReportGenerator(ReportsGenerationInputs reportsGenerationInputs, ChartsFiles chartsFiles, ComponentLibrary componentLibrary, ZoneId zoneId, Charset charset, ReportsConfiguration configuration) {
        this.reportsGenerationInputs = reportsGenerationInputs;
        this.chartsFiles = chartsFiles;
        this.componentLibrary = componentLibrary;
        this.zoneId = zoneId;
        this.charset = charset;
        this.configuration = configuration;
    }
}

