/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.report;

import io.gatling.charts.component.Component;
import io.gatling.charts.component.ComponentLibrary;
import io.gatling.charts.component.DetailsStatsTableComponent;
import io.gatling.charts.component.ErrorsTableComponent;
import io.gatling.charts.config.ChartsFiles;
import io.gatling.charts.report.GroupContainer;
import io.gatling.charts.report.ReportGenerator;
import io.gatling.charts.report.RequestContainer;
import io.gatling.charts.report.SchemaContainerComponent;
import io.gatling.charts.report.TemplateWriter;
import io.gatling.charts.stats.CountsVsTimePlot;
import io.gatling.charts.stats.LogFileData;
import io.gatling.charts.stats.PercentVsTimePlot;
import io.gatling.charts.stats.PercentilesVsTimePlot;
import io.gatling.charts.stats.Ranges;
import io.gatling.charts.stats.RequestPath$;
import io.gatling.charts.stats.Series$;
import io.gatling.charts.template.DetailsPageTemplate;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.core.config.ReportsConfiguration;
import java.io.Serializable;
import java.nio.charset.Charset;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005]3Q!\u0003\u0006\u0001\u0019IA\u0001\"\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0011!9\u0004A!A!\u0002\u0013A\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u000b%\u0003A\u0011\u0001&\t\u000bI\u0003A\u0011A*\u0003;I+\u0017/^3ti\u0012+G/Y5mgJ+\u0007o\u001c:u\u000f\u0016tWM]1u_JT!a\u0003\u0007\u0002\rI,\u0007o\u001c:u\u0015\tia\"\u0001\u0004dQ\u0006\u0014Ho\u001d\u0006\u0003\u001fA\tqaZ1uY&twMC\u0001\u0012\u0003\tIwnE\u0002\u0001'e\u0001\"\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u0011a!\u00118z%\u00164\u0007C\u0001\u000e\u001c\u001b\u0005Q\u0011B\u0001\u000f\u000b\u0005=\u0011V\r]8si\u001e+g.\u001a:bi>\u0014\u0018a\u00037pO\u001aKG.\u001a#bi\u0006\u001c\u0001\u0001\u0005\u0002!G5\t\u0011E\u0003\u0002#\u0019\u0005)1\u000f^1ug&\u0011A%\t\u0002\f\u0019><g)\u001b7f\t\u0006$\u0018-A\u0007s_>$8i\u001c8uC&tWM\u001d\t\u00035\u001dJ!\u0001\u000b\u0006\u0003\u001d\u001d\u0013x.\u001e9D_:$\u0018-\u001b8fe\u0006Y1\r[1siN4\u0015\u000e\\3t!\tYc&D\u0001-\u0015\tiC\"\u0001\u0004d_:4\u0017nZ\u0005\u0003_1\u00121b\u00115beR\u001ch)\u001b7fg\u0006\u00012m\\7q_:,g\u000e\u001e'jEJ\f'/\u001f\t\u0003eUj\u0011a\r\u0006\u0003i1\t\u0011bY8na>tWM\u001c;\n\u0005Y\u001a$\u0001E\"p[B|g.\u001a8u\u0019&\u0014'/\u0019:z\u0003\u001d\u0019\u0007.\u0019:tKR\u0004\"!O \u000e\u0003iR!aN\u001e\u000b\u0005qj\u0014a\u00018j_*\ta(\u0001\u0003kCZ\f\u0017B\u0001!;\u0005\u001d\u0019\u0005.\u0019:tKR\fQbY8oM&<WO]1uS>t\u0007CA\"H\u001b\u0005!%BA\u0017F\u0015\t1e\"\u0001\u0003d_J,\u0017B\u0001%E\u0005Q\u0011V\r]8siN\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u00061A(\u001b8jiz\"ra\u0013'N\u001d>\u0003\u0016\u000b\u0005\u0002\u001b\u0001!)Qd\u0002a\u0001?!)Qe\u0002a\u0001M!)\u0011f\u0002a\u0001U!)\u0001g\u0002a\u0001c!)qg\u0002a\u0001q!)\u0011i\u0002a\u0001\u0005\u0006Aq-\u001a8fe\u0006$X\rF\u0001U!\t!R+\u0003\u0002W+\t!QK\\5u\u0001")
public class RequestDetailsReportGenerator
implements ReportGenerator {
    private final LogFileData logFileData;
    private final GroupContainer rootContainer;
    private final ChartsFiles chartsFiles;
    private final ComponentLibrary componentLibrary;
    private final Charset charset;
    private final ReportsConfiguration configuration;

    @Override
    public void generate() {
        this.generateDetailPageRec$1(this.rootContainer);
    }

    private final Component responseTimeDistributionChartComponent$1(RequestContainer requestContainer$1) {
        Tuple2<Seq<PercentVsTimePlot>, Seq<PercentVsTimePlot>> tuple2 = this.logFileData.responseTimeDistribution(100, (Option<String>)new Some((Object)requestContainer$1.name()), requestContainer$1.group());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq okDistribution = (Seq)tuple2._1();
        Seq koDistribution = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)okDistribution, (Object)koDistribution);
        Seq okDistribution2 = (Seq)tuple22._1();
        Seq koDistribution2 = (Seq)tuple22._2();
        return this.componentLibrary.getDistributionComponent("responseTimeDistributionContainerId", "Response Time", "Requests", (Seq<PercentVsTimePlot>)okDistribution2, (Seq<PercentVsTimePlot>)koDistribution2);
    }

    private final Component responseTimeChartComponent$1(RequestContainer requestContainer$1) {
        Seq<PercentilesVsTimePlot> successData = this.logFileData.responseTimePercentilesOverTime((Status)OK$.MODULE$, (Option<String>)new Some((Object)requestContainer$1.name()), requestContainer$1.group());
        return this.componentLibrary.getPercentilesOverTimeComponent("responseTimeOverTimeContainerId", "Response Time Percentiles over Time (" + Series$.MODULE$.OK() + ")", "Response Time", this.logFileData.runInfo().injectStart(), successData);
    }

    private final Component requestsChartComponent$1(RequestContainer requestContainer$1) {
        return this.componentLibrary.getRequestsComponent("requestsContainerId", this.logFileData.runInfo().injectStart(), (Seq<CountsVsTimePlot>)((Seq)this.logFileData.numberOfRequestsPerSecond((Option<String>)new Some((Object)requestContainer$1.name()), requestContainer$1.group()).sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.time()), (Ordering)Ordering.Int$.MODULE$)));
    }

    private final Component responsesChartComponent$1(RequestContainer requestContainer$1) {
        return this.componentLibrary.getResponsesComponent("responsesContainerId", this.logFileData.runInfo().injectStart(), (Seq<CountsVsTimePlot>)((Seq)this.logFileData.numberOfResponsesPerSecond((Option<String>)new Some((Object)requestContainer$1.name()), requestContainer$1.group()).sortBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.time()), (Ordering)Ordering.Int$.MODULE$)));
    }

    private final Component responseTimeScatterChartComponent$1(RequestContainer requestContainer$1) {
        return this.componentLibrary.getResponseTimeScatterComponent("responseTimeScatterContainerId", this.logFileData.responseTimeAgainstGlobalNumberOfRequestsPerSec((Status)OK$.MODULE$, requestContainer$1.name(), requestContainer$1.group()), this.logFileData.responseTimeAgainstGlobalNumberOfRequestsPerSec((Status)KO$.MODULE$, requestContainer$1.name(), requestContainer$1.group()));
    }

    private final void generateDetailPage$1(RequestContainer requestContainer) {
        Ranges ranges = this.logFileData.numberOfRequestInResponseTimeRanges((Option<String>)new Some((Object)requestContainer.name()), requestContainer.group());
        String path = RequestPath$.MODULE$.path(requestContainer.name(), requestContainer.group());
        DetailsPageTemplate template = new DetailsPageTemplate(this.logFileData.runInfo(), path, requestContainer, this.rootContainer, (Seq<Component>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Component[]{new SchemaContainerComponent((Seq<Component>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Component[]{this.componentLibrary.getRangesComponent("RangesContainerId", "Response Time Ranges", "requests", ranges, true), new DetailsStatsTableComponent(requestContainer.stats(), this.configuration.indicators())})), new ErrorsTableComponent(this.logFileData.errors((Option<String>)new Some((Object)requestContainer.name()), requestContainer.group())), this.responseTimeDistributionChartComponent$1(requestContainer), this.responseTimeChartComponent$1(requestContainer), this.requestsChartComponent$1(requestContainer), this.responsesChartComponent$1(requestContainer), this.responseTimeScatterChartComponent$1(requestContainer)}));
        new TemplateWriter(this.chartsFiles.requestFile(path)).writeToFile(template.getOutput(), this.charset);
    }

    private final void generateDetailPageRec$1(GroupContainer groupContainer2) {
        groupContainer2.requests().values().foreach((Function1 & Serializable)requestContainer -> {
            this.generateDetailPage$1(requestContainer);
            return BoxedUnit.UNIT;
        });
        groupContainer2.groups().values().foreach((Function1 & Serializable)groupContainer -> {
            this.generateDetailPageRec$1(groupContainer);
            return BoxedUnit.UNIT;
        });
    }

    public RequestDetailsReportGenerator(LogFileData logFileData, GroupContainer rootContainer, ChartsFiles chartsFiles, ComponentLibrary componentLibrary, Charset charset, ReportsConfiguration configuration) {
        this.logFileData = logFileData;
        this.rootContainer = rootContainer;
        this.chartsFiles = chartsFiles;
        this.componentLibrary = componentLibrary;
        this.charset = charset;
        this.configuration = configuration;
    }
}

