/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.util.Longs;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005e4Qa\u0003\u0007\u0003\u0019YA\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\tm\u0001\u0011\t\u0011)A\u0005o!AQ\b\u0001B\u0001B\u0003%a\bC\u0003C\u0001\u0011\u00051\tC\u0003J\u0001\u0011\u0005!\nC\u0003R\u0001\u0011%!\u000bC\u0003Y\u0001\u0011\u0005\u0011\fC\u0003c\u0001\u0011\u00051\rC\u0003r\u0001\u0011\u0005!\u000fC\u0003y\u0001\u0011\u0005#JA\rCk\u001a4WM]3e\r&dWm\u00115b]:,Gn\u0016:ji\u0016\u0014(BA\u0007\u000f\u0003\u00199(/\u001b;fe*\u0011q\u0002E\u0001\u0006gR\fGo\u001d\u0006\u0003#I\tAaY8sK*\u00111\u0003F\u0001\bO\u0006$H.\u001b8h\u0015\u0005)\u0012AA5p'\u0011\u0001qc\b\u0012\u0011\u0005aiR\"A\r\u000b\u0005iY\u0012\u0001\u00027b]\u001eT\u0011\u0001H\u0001\u0005U\u00064\u0018-\u0003\u0002\u001f3\t1qJ\u00196fGR\u0004\"\u0001\u0007\u0011\n\u0005\u0005J\"!D!vi>\u001cEn\\:fC\ndW\r\u0005\u0002$U5\tAE\u0003\u0002&M\u0005a1oY1mC2|wmZ5oO*\u0011q\u0005K\u0001\tif\u0004Xm]1gK*\t\u0011&A\u0002d_6L!a\u000b\u0013\u0003\u001bM#(/[2u\u0019><w-\u001b8h\u0003\u001d\u0019\u0007.\u00198oK2\u001c\u0001\u0001\u0005\u00020i5\t\u0001G\u0003\u00022e\u0005A1\r[1o]\u0016d7O\u0003\u000247\u0005\u0019a.[8\n\u0005U\u0002$a\u0003$jY\u0016\u001c\u0005.\u00198oK2\fq!\u001a8d_\u0012,'\u000f\u0005\u00029w5\t\u0011H\u0003\u0002;e\u000591\r[1sg\u0016$\u0018B\u0001\u001f:\u00059\u0019\u0005.\u0019:tKR,enY8eKJ\f!A\u00192\u0011\u0005}\u0002U\"\u0001\u001a\n\u0005\u0005\u0013$A\u0003\"zi\u0016\u0014UO\u001a4fe\u00061A(\u001b8jiz\"B\u0001\u0012$H\u0011B\u0011Q\tA\u0007\u0002\u0019!)A\u0006\u0002a\u0001]!)a\u0007\u0002a\u0001o!)Q\b\u0002a\u0001}\u0005)a\r\\;tQR\t1\n\u0005\u0002M\u001f6\tQJC\u0001O\u0003\u0015\u00198-\u00197b\u0013\t\u0001VJ\u0001\u0003V]&$\u0018AD3ogV\u0014XmQ1qC\u000eLG/\u001f\u000b\u0003\u0017NCQ\u0001\u0016\u0004A\u0002U\u000b\u0011!\u001b\t\u0003\u0019ZK!aV'\u0003\u0007%sG/\u0001\u0006xe&$XMQ=uKN$\"a\u0013.\t\u000bm;\u0001\u0019\u0001/\u0002\u000b\tLH/Z:\u0011\u00071kv,\u0003\u0002_\u001b\n)\u0011I\u001d:bsB\u0011A\nY\u0005\u0003C6\u0013AAQ=uK\u0006YqO]5uKN#(/\u001b8h)\tYE\rC\u0003f\u0011\u0001\u0007a-\u0001\u0004tiJLgn\u001a\t\u0003O:t!\u0001\u001b7\u0011\u0005%lU\"\u00016\u000b\u0005-l\u0013A\u0002\u001fs_>$h(\u0003\u0002n\u001b\u00061\u0001K]3eK\u001aL!a\u001c9\u0003\rM#(/\u001b8h\u0015\tiW*A\txe&$X\rU8tSRLg/\u001a'p]\u001e$\"aS:\t\u000bQL\u0001\u0019A;\u0002\u00031\u0004\"\u0001\u0014<\n\u0005]l%\u0001\u0002'p]\u001e\fQa\u00197pg\u0016\u0004")
public final class BufferedFileChannelWriter
implements AutoCloseable,
StrictLogging {
    private final FileChannel channel;
    private final CharsetEncoder encoder;
    private final ByteBuffer bb;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void flush() {
        this.bb.flip();
        while (this.bb.hasRemaining()) {
            this.channel.write(this.bb);
        }
        this.bb.clear();
    }

    private void ensureCapacity(int i) {
        if (this.bb.remaining() < i) {
            this.flush();
            return;
        }
    }

    public void writeBytes(byte[] bytes) {
        this.ensureCapacity(bytes.length);
        this.bb.put(bytes);
    }

    public void writeString(String string) {
        this.ensureCapacity(string.length() * 4);
        CoderResult coderResult = this.encoder.encode(CharBuffer.wrap(string), this.bb, false);
        if (coderResult.isOverflow()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Buffer overflow, you shouldn't be logging that much data. Truncating.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void writePositiveLong(long l) {
        int stringSize = Longs.positiveLongStringSize(l);
        this.ensureCapacity(stringSize);
        Longs.writePositiveLongString(l, stringSize, this.bb);
    }

    @Override
    public void close() {
        try {
            this.flush();
            this.channel.force(true);
        }
        finally {
            this.channel.close();
        }
    }

    public BufferedFileChannelWriter(FileChannel channel, CharsetEncoder encoder, ByteBuffer bb) {
        this.channel = channel;
        this.encoder = encoder;
        this.bb = bb;
        StrictLogging.$init$((StrictLogging)this);
        Statics.releaseFence();
    }
}

