/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.Session;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function1;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u00153A!\u0003\u0006\u0003'!A!\u0004\u0001B\u0001B\u0003%1\u0004C\u0003#\u0001\u0011\u00051\u0005C\u0004(\u0001\t\u0007I\u0011\u0002\u0015\t\rQ\u0002\u0001\u0015!\u0003*\u0011\u001d)\u0004A1A\u0005\nYBa!\u0010\u0001!\u0002\u00139\u0004\"\u0002 \u0001\t\u0003y\u0004\"\u0002!\u0001\t\u0003\t%A\u0004&ngN+7o]5p]B{w\u000e\u001c\u0006\u0003\u00171\taa\u00197jK:$(BA\u0007\u000f\u0003\rQWn\u001d\u0006\u0003\u001fA\tqaZ1uY&twMC\u0001\u0012\u0003\tIwn\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g-\u0001\u0006d_:tWm\u0019;j_:\u0004\"\u0001\b\u0011\u000e\u0003uQ!!\u0004\u0010\u000b\u0003}\tqA[1lCJ$\u0018-\u0003\u0002\";\tQ1i\u001c8oK\u000e$\u0018n\u001c8\u0002\rqJg.\u001b;?)\t!c\u0005\u0005\u0002&\u00015\t!\u0002C\u0003\u001b\u0005\u0001\u00071$A\u000bsK\u001eL7\u000f^3sK\u0012TUn]*fgNLwN\\:\u0016\u0003%\u00022AK\u00182\u001b\u0005Y#B\u0001\u0017.\u0003\u0011)H/\u001b7\u000b\u00039\nAA[1wC&\u0011\u0001g\u000b\u0002\u0004'\u0016$\bC\u0001\u000f3\u0013\t\u0019TDA\u0004TKN\u001c\u0018n\u001c8\u0002-I,w-[:uKJ,GMS7t'\u0016\u001c8/[8og\u0002\n1B[7t'\u0016\u001c8/[8ogV\tq\u0007E\u00029wEj\u0011!\u000f\u0006\u0003u5\nA\u0001\\1oO&\u0011A(\u000f\u0002\f)\"\u0014X-\u00193M_\u000e\fG.\u0001\u0007k[N\u001cVm]:j_:\u001c\b%\u0001\u0006k[N\u001cVm]:j_:$\u0012!M\u0001\u0006G2|7/\u001a\u000b\u0002\u0005B\u0011QcQ\u0005\u0003\tZ\u0011A!\u00168ji\u0002")
public final class JmsSessionPool {
    private final Connection connection;
    private final Set<Session> registeredJmsSessions;
    private final ThreadLocal<Session> jmsSessions;

    private Set<Session> registeredJmsSessions() {
        return this.registeredJmsSessions;
    }

    private ThreadLocal<Session> jmsSessions() {
        return this.jmsSessions;
    }

    public Session jmsSession() {
        return this.jmsSessions().get();
    }

    public void close() {
        CollectionConverters$.MODULE$.SetHasAsScala(this.registeredJmsSessions()).asScala().foreach((Function1 & Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
    }

    public JmsSessionPool(Connection connection) {
        this.connection = connection;
        this.registeredJmsSessions = Collections.newSetFromMap(new ConcurrentHashMap());
        this.jmsSessions = ThreadLocal.withInitial(() -> {
            Session s = $this.connection.createSession(false, 1);
            this.registeredJmsSessions().add(s);
            return s;
        });
    }
}

