/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.AbstractGatlingExecutionMojo;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="verify", defaultPhase=LifecyclePhase.VERIFY)
public final class VerifyMojo
extends AbstractGatlingExecutionMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping gatling-maven-plugin");
        } else {
            this.executePlugin();
        }
    }

    private void executePlugin() throws MojoFailureException, MojoExecutionException {
        try {
            this.verifyLastRun();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not read result files.", (Exception)e);
        }
    }

    private void verifyLastRun() throws IOException, MojoFailureException, MojoExecutionException {
        Path results = this.resultsFolder.toPath().resolve("lastRun.txt");
        if (results.toFile().exists()) {
            for (String line : Files.readAllLines(results)) {
                this.checkError(line);
            }
        }
    }

    private void checkError(String line) throws MojoFailureException {
        if (line.contains("ExecutionError: ")) {
            this.throwFailureException(line.substring("ExecutionError: ".length()));
        }
    }

    private void throwFailureException(String message) throws MojoFailureException {
        this.getLog().error((CharSequence)message);
        this.getLog().error((CharSequence)("See the reports in " + this.resultsFolder.getPath() + " for details."));
        throw new MojoFailureException(message);
    }
}

