/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache;

import coursierapi.shaded.coursier.cache.ArtifactError;
import coursierapi.shaded.coursier.cache.Cache;
import coursierapi.shaded.coursier.cache.CacheChecksum$;
import coursierapi.shaded.coursier.cache.CacheLogger;
import coursierapi.shaded.coursier.cache.CachePolicy;
import coursierapi.shaded.coursier.cache.FileCache$;
import coursierapi.shaded.coursier.cache.internal.DownloadResult;
import coursierapi.shaded.coursier.cache.internal.Downloader$;
import coursierapi.shaded.coursier.core.Authentication;
import coursierapi.shaded.coursier.credentials.Credentials;
import coursierapi.shaded.coursier.credentials.DirectCredentials;
import coursierapi.shaded.coursier.util.Artifact;
import coursierapi.shaded.coursier.util.EitherT;
import coursierapi.shaded.coursier.util.Monad$ops$;
import coursierapi.shaded.coursier.util.Sync;
import coursierapi.shaded.coursier.util.WebPage$;
import coursierapi.shaded.scala.$less$colon$less$;
import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.Function2;
import coursierapi.shaded.scala.MatchError;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Option$;
import coursierapi.shaded.scala.Predef$;
import coursierapi.shaded.scala.Predef$ArrowAssoc$;
import coursierapi.shaded.scala.Product;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.Tuple3;
import coursierapi.shaded.scala.collection.ArrayOps$;
import coursierapi.shaded.scala.collection.IterableOnceOps;
import coursierapi.shaded.scala.collection.IterableOps;
import coursierapi.shaded.scala.collection.Iterator;
import coursierapi.shaded.scala.collection.SeqOps;
import coursierapi.shaded.scala.collection.StringOps$;
import coursierapi.shaded.scala.collection.immutable.Map;
import coursierapi.shaded.scala.collection.immutable.Seq;
import coursierapi.shaded.scala.concurrent.ExecutionContext$;
import coursierapi.shaded.scala.concurrent.ExecutionContextExecutorService;
import coursierapi.shaded.scala.concurrent.duration.Duration;
import coursierapi.shaded.scala.math.Ordering$String$;
import coursierapi.shaded.scala.package$;
import coursierapi.shaded.scala.reflect.ClassTag$;
import coursierapi.shaded.scala.runtime.BoxedUnit;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.ScalaRunTime$;
import coursierapi.shaded.scala.runtime.Statics;
import coursierapi.shaded.scala.util.Either;
import coursierapi.shaded.scala.util.Left;
import coursierapi.shaded.scala.util.Right;
import coursierapi.shaded.scala.util.control.NonFatal$;
import java.io.File;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public final class FileCache<F>
extends Cache<F>
implements Serializable,
Product {
    private Seq<DirectCredentials> allCredentials0;
    private ExecutionContextExecutorService ec;
    private final File location;
    private final Seq<CachePolicy> cachePolicies;
    private final Seq<Option<String>> checksums;
    private final Seq<Credentials> credentials;
    private final CacheLogger logger;
    private final ExecutorService pool;
    private final Option<Duration> ttl;
    private final boolean localArtifactsShouldBeCached;
    private final boolean followHttpToHttpsRedirections;
    private final boolean followHttpsToHttpRedirections;
    private final Option<Object> maxRedirections;
    private final int sslRetry;
    private final Option<SSLSocketFactory> sslSocketFactoryOpt;
    private final Option<HostnameVerifier> hostnameVerifierOpt;
    private final int retry;
    private final int bufferSize;
    private final Seq<ClassLoader> classLoaders;
    private final Sync<F> sync;
    private final Seq<Option<String>> checksums0;
    private final Seq<String> actualChecksums;
    private volatile byte bitmap$0;

    @Override
    public Iterator<Object> productIterator() {
        return Product.productIterator$(this);
    }

    public File location() {
        return this.location;
    }

    public Seq<CachePolicy> cachePolicies() {
        return this.cachePolicies;
    }

    public Seq<Option<String>> checksums() {
        return this.checksums;
    }

    public Seq<Credentials> credentials() {
        return this.credentials;
    }

    public CacheLogger logger() {
        return this.logger;
    }

    public ExecutorService pool() {
        return this.pool;
    }

    public Option<Duration> ttl() {
        return this.ttl;
    }

    public boolean localArtifactsShouldBeCached() {
        return this.localArtifactsShouldBeCached;
    }

    public boolean followHttpToHttpsRedirections() {
        return this.followHttpToHttpsRedirections;
    }

    public boolean followHttpsToHttpRedirections() {
        return this.followHttpsToHttpRedirections;
    }

    public Option<Object> maxRedirections() {
        return this.maxRedirections;
    }

    public int sslRetry() {
        return this.sslRetry;
    }

    public Option<SSLSocketFactory> sslSocketFactoryOpt() {
        return this.sslSocketFactoryOpt;
    }

    public Option<HostnameVerifier> hostnameVerifierOpt() {
        return this.hostnameVerifierOpt;
    }

    public int retry() {
        return this.retry;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public Seq<ClassLoader> classLoaders() {
        return this.classLoaders;
    }

    public Sync<F> sync() {
        return this.sync;
    }

    private Sync<F> S() {
        return this.sync();
    }

    private Seq<DirectCredentials> allCredentials0$lzycompute() {
        FileCache fileCache = this;
        synchronized (fileCache) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.allCredentials0 = (Seq)this.credentials().flatMap((Function1<Credentials, Seq> & Serializable)x$1 -> x$1.get());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.allCredentials0;
    }

    private Seq<DirectCredentials> allCredentials0() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.allCredentials0$lzycompute() : this.allCredentials0;
    }

    public F allCredentials() {
        return this.S().delay((Function0<Seq> & Serializable)() -> this.allCredentials0());
    }

    public FileCache<F> noCredentials() {
        return this.withCredentials(package$.MODULE$.Nil());
    }

    public File localFile(String url, Option<String> user) {
        return FileCache$.MODULE$.localFile0(url, this.location(), user, this.localArtifactsShouldBeCached());
    }

    public Some<CacheLogger> loggerOpt() {
        return new Some<CacheLogger>(this.logger());
    }

    private Seq<Option<String>> checksums0() {
        return this.checksums0;
    }

    private Seq<String> actualChecksums() {
        return this.actualChecksums;
    }

    private F download(Artifact artifact, CachePolicy cachePolicy) {
        return Downloader$.MODULE$.apply(artifact, cachePolicy, this.location(), this.actualChecksums(), this.allCredentials(), this.logger(), this.pool(), this.ttl(), this.localArtifactsShouldBeCached(), this.followHttpToHttpsRedirections(), this.followHttpsToHttpRedirections(), this.maxRedirections(), this.sslRetry(), this.sslSocketFactoryOpt(), this.hostnameVerifierOpt(), this.bufferSize(), this.classLoaders(), this.sync()).download();
    }

    public EitherT<F, ArtifactError, BoxedUnit> validateChecksum(Artifact artifact, String sumType) {
        File localFile0 = this.localFile(artifact.url(), artifact.authentication().map((Function1<Authentication, String> & Serializable)x$3 -> x$3.user()));
        Seq headerSumFile = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{FileCache$.MODULE$.auxiliaryFile(localFile0, sumType)}));
        Option downloadedSumFile = artifact.checksumUrls().get(sumType).map((Function1<String, File> & Serializable)sumUrl -> this.localFile((String)sumUrl, artifact.authentication().map((Function1<Authentication, String> & Serializable)x$4 -> x$4.user())));
        return new EitherT(this.S().schedule(this.pool(), (Function0<Either> & Serializable)() -> {
            Left left;
            Option option = ((IterableOnceOps)headerSumFile.$plus$plus(Option$.MODULE$.option2Iterable(downloadedSumFile).toSeq())).find((Function1<File, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(x$5.exists()));
            if (option instanceof Some) {
                Either either;
                Some some = (Some)option;
                File sumFile = (File)some.value();
                Option<BigInteger> sumOpt = CacheChecksum$.MODULE$.parseRawChecksum(Files.readAllBytes(sumFile.toPath()));
                Option<BigInteger> option2 = sumOpt;
                if (None$.MODULE$.equals(option2)) {
                    either = package$.MODULE$.Left().apply(new ArtifactError.ChecksumFormatError(sumType, sumFile.getPath()));
                } else if (option2 instanceof Some) {
                    BigInteger calculatedSum;
                    Some some2 = (Some)option2;
                    BigInteger sum = (BigInteger)some2.value();
                    either = BoxesRunTime.equalsNumNum(sum, calculatedSum = FileCache$.MODULE$.coursier$cache$FileCache$$persistedDigest(this.location(), sumType, localFile0)) ? package$.MODULE$.Right().apply(BoxedUnit.UNIT) : package$.MODULE$.Left().apply(new ArtifactError.WrongChecksum(sumType, calculatedSum.toString(16), sum.toString(16), localFile0.getPath(), sumFile.getPath()));
                } else {
                    throw new MatchError(option2);
                }
                left = either;
            } else if (None$.MODULE$.equals(option)) {
                ArtifactError.ChecksumNotFound err = new ArtifactError.ChecksumNotFound(sumType, localFile0.getPath());
                left = package$.MODULE$.Left().apply(err);
            } else {
                throw new MatchError(option);
            }
            return left;
        }));
    }

    private EitherT<F, ArtifactError, File> filePerPolicy(Artifact artifact, CachePolicy policy, int retry) {
        Object artifact0 = Monad$ops$.MODULE$.toAllMonadOps(this.allCredentials(), this.sync()).map((Function1<Seq, Artifact> & Serializable)allCredentials -> {
            Artifact artifact;
            if (artifact.authentication().isEmpty()) {
                Option<Authentication> authOpt = allCredentials.find((Function1<DirectCredentials, Object> & Serializable)x$6 -> BoxesRunTime.boxToBoolean(x$6.autoMatches(artifact.url(), None$.MODULE$))).map((Function1<DirectCredentials, Authentication> & Serializable)x$7 -> x$7.authentication());
                artifact = artifact.withAuthentication(authOpt);
            } else {
                artifact = artifact;
            }
            return artifact;
        });
        return new EitherT(Monad$ops$.MODULE$.toAllMonadOps(artifact0, this.sync()).map((Function1<Artifact, Right> & Serializable)x$8 -> package$.MODULE$.Right().apply(x$8))).flatMap((Function1<Artifact, EitherT> & Serializable)a -> this.filePerPolicy0((Artifact)a, policy, retry), this.sync());
    }

    private EitherT<F, ArtifactError, File> filePerPolicy0(Artifact artifact, CachePolicy policy, int retry) {
        return new EitherT(Monad$ops$.MODULE$.toAllMonadOps(this.download(artifact, policy), this.sync()).map((Function1<Seq, Either> & Serializable)results -> {
            Map resultsMap = ((IterableOnceOps)results.map((Function1<DownloadResult, Tuple2> & Serializable)x0$1 -> {
                DownloadResult downloadResult = x0$1;
                Tuple2<String, Option<ArtifactError>> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(downloadResult.url()), downloadResult.errorOpt());
                return tuple2;
            })).toMap($less$colon$less$.MODULE$.refl());
            Seq checksumResults = (Seq)this.checksums0().map((Function1<Option, Option> & Serializable)x0$2 -> {
                Option option;
                Option option2 = x0$2;
                if (None$.MODULE$.equals(option2)) {
                    option = None$.MODULE$;
                } else if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    String c = (String)some.value();
                    String url = (String)artifact.checksumUrls().getOrElse(c, (Function0<String> & Serializable)() -> new StringBuilder(1).append(artifact.url()).append(".").append(StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(c.toLowerCase(Locale.ROOT)), (Function1<Object, Object> & Serializable)x$9 -> BoxesRunTime.boxToBoolean(FileCache.$anonfun$filePerPolicy0$5(BoxesRunTime.unboxToChar(x$9))))).toString());
                    option = new Some(new Tuple3(c, url, resultsMap.get(url)));
                } else {
                    throw new MatchError(option2);
                }
                return option;
            });
            Option<Option<String>> checksum = checksumResults.collectFirst(new Serializable(null){

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Option<Tuple3<String, String, Option<Option<ArtifactError>>>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Some some;
                    Tuple3 tuple3;
                    void var3_7;
                    A1 A1 = x1;
                    if (None$.MODULE$.equals(A1)) {
                        None$ none$ = None$.MODULE$;
                        return var3_7;
                    }
                    if (A1 instanceof Some && (tuple3 = (Tuple3)(some = (Some)A1).value()) != null) {
                        Some some2;
                        Option errorOpt;
                        String c = (String)tuple3._1();
                        Option option = (Option)tuple3._3();
                        if (option instanceof Some && (errorOpt = (Option)(some2 = (Some)option).value()).isEmpty()) {
                            Some<String> some3 = new Some<String>(c);
                            return var3_7;
                        }
                    }
                    B1 B1 = function1.apply(x1);
                    return var3_7;
                }

                public final boolean isDefinedAt(Option<Tuple3<String, String, Option<Option<ArtifactError>>>> x1) {
                    Some some;
                    Option errorOpt;
                    Option option;
                    Some some2;
                    Tuple3 tuple3;
                    Option<Tuple3<String, String, Option<Option<ArtifactError>>>> option2 = x1;
                    boolean bl = None$.MODULE$.equals(option2) ? true : option2 instanceof Some && (tuple3 = (Tuple3)(some2 = (Some)option2).value()) != null && (option = (Option)tuple3._3()) instanceof Some && (errorOpt = (Option)(some = (Some)option).value()).isEmpty();
                    return bl;
                }
            });
            DownloadResult res = (DownloadResult)results.head();
            return res.errorOpt().toLeft(() -> {}).flatMap((Function1<BoxedUnit, Either> & Serializable)x$10 -> {
                Either either;
                Option option = checksum;
                if (None$.MODULE$.equals(option)) {
                    either = package$.MODULE$.Left().apply(new ArtifactError.ChecksumErrors(FileCache.checksumErrors$1(checksumResults)));
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    Option c = (Option)some.value();
                    either = package$.MODULE$.Right().apply(new Tuple2<File, Option>(res.file(), c));
                } else {
                    throw new MatchError(option);
                }
                return either;
            });
        })).flatMap((Function1<Tuple2, EitherT> & Serializable)x0$3 -> {
            void var3_8;
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                File f = (File)tuple2._1();
                Option option = (Option)tuple2._2();
                if (None$.MODULE$.equals(option)) {
                    EitherT eitherT = new EitherT(this.S().point(package$.MODULE$.Right().apply(f)));
                    return var3_8;
                }
            }
            if (tuple2 == null) throw new MatchError(tuple2);
            File f = (File)tuple2._1();
            Option option = (Option)tuple2._2();
            if (!(option instanceof Some)) throw new MatchError(tuple2);
            Some some = (Some)option;
            String c = (String)some.value();
            EitherT eitherT = this.validateChecksum(artifact, c).map((Function1<BoxedUnit, File> & Serializable)x$11 -> f, this.sync());
            return var3_8;
        }, this.sync()).leftFlatMap((Function1<ArtifactError, EitherT> & Serializable)x0$4 -> {
            EitherT eitherT;
            ArtifactError artifactError = x0$4;
            if (artifactError instanceof ArtifactError.WrongChecksum) {
                ArtifactError.WrongChecksum wrongChecksum = (ArtifactError.WrongChecksum)artifactError;
                File badFile = this.localFile(artifact.url(), artifact.authentication().map((Function1<Authentication, String> & Serializable)x$12 -> x$12.user()));
                File badChecksumFile = new File(wrongChecksum.sumFile());
                String location0 = new StringBuilder(0).append(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(this.location().getCanonicalPath()), File.separator)).append(File.separator).toString();
                boolean foundBadFileInCache = badFile.getCanonicalPath().startsWith(location0) && badChecksumFile.getCanonicalPath().startsWith(location0);
                eitherT = retry <= 0 || !foundBadFileInCache ? new EitherT(this.S().point(package$.MODULE$.Left().apply(wrongChecksum))) : new EitherT(this.S().schedule(this.pool(), (Function0<Right> & Serializable)() -> {
                    Predef$.MODULE$.assert(foundBadFileInCache);
                    badFile.delete();
                    badChecksumFile.delete();
                    FileCache$.MODULE$.clearAuxiliaryFiles(badFile);
                    this.logger().removedCorruptFile(artifact.url(), new Some<String>(wrongChecksum.describe()));
                    return package$.MODULE$.Right().apply(BoxedUnit.UNIT);
                })).flatMap((Function1<BoxedUnit, EitherT> & Serializable)x$13 -> this.filePerPolicy0(artifact, policy, retry - 1), this.sync());
            } else {
                eitherT = new EitherT(this.S().point(package$.MODULE$.Left().apply(artifactError)));
            }
            return eitherT;
        }, this.sync());
    }

    @Override
    public EitherT<F, ArtifactError, File> file(Artifact artifact) {
        return this.file(artifact, this.retry());
    }

    public EitherT<F, ArtifactError, File> file(Artifact artifact, int retry) {
        return ((IterableOnceOps)((IterableOps)this.cachePolicies().tail()).map((Function1<CachePolicy, EitherT> & Serializable)x$14 -> this.filePerPolicy(artifact, (CachePolicy)x$14, retry))).foldLeft(this.filePerPolicy(artifact, (CachePolicy)this.cachePolicies().head(), retry), (Function2<EitherT, EitherT, EitherT> & Serializable)(x$15, x$16) -> x$15.orElse((Function0<EitherT> & Serializable)() -> x$16, this.sync()));
    }

    private int filePerPolicy$default$3() {
        return this.retry();
    }

    private EitherT<F, String, String> fetchPerPolicy(Artifact artifact, CachePolicy policy) {
        Tuple2<Artifact, Boolean> tuple2;
        Tuple2<Artifact, Boolean> tuple22 = tuple2 = artifact.url().endsWith("/.links") ? new Tuple2<Artifact, Boolean>(artifact.withUrl(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(artifact.url()), ".links")), BoxesRunTime.boxToBoolean(true)) : new Tuple2<Artifact, Boolean>(artifact, BoxesRunTime.boxToBoolean(false));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Artifact artifact0 = (Artifact)tuple2._1();
        boolean links = tuple2._2$mcZ$sp();
        Tuple2<Artifact, Boolean> tuple23 = new Tuple2<Artifact, Boolean>(artifact0, BoxesRunTime.boxToBoolean(links));
        Tuple2<Artifact, Boolean> tuple24 = tuple23;
        Artifact artifact02 = tuple24._1();
        boolean links2 = tuple24._2$mcZ$sp();
        return this.filePerPolicy(artifact02, policy, this.filePerPolicy$default$3()).leftMap((Function1<ArtifactError, String> & Serializable)x$18 -> x$18.describe(), this.sync()).flatMap((Function1<File, EitherT> & Serializable)f -> {
            Either either;
            if (f.exists()) {
                if (f.isDirectory()) {
                    if (artifact02.url().startsWith("file:")) {
                        String string;
                        if (links2) {
                            string = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(f.listFiles()), (Function1<File, String> & Serializable)c -> {
                                void var1_1;
                                String name = c.getName();
                                return c.isDirectory() ? new StringBuilder(1).append(name).append("/").toString() : var1_1;
                            }, ClassTag$.MODULE$.apply(String.class))), Ordering$String$.MODULE$)).mkString("\n");
                        } else {
                            String elements = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(f.listFiles()), (Function1<File, String> & Serializable)c -> {
                                void var1_1;
                                String name = c.getName();
                                return c.isDirectory() ? new StringBuilder(1).append(name).append("/").toString() : var1_1;
                            }, ClassTag$.MODULE$.apply(String.class))), Ordering$String$.MODULE$)), (Function1<String, String> & Serializable)name0 -> new StringBuilder(24).append("<li><a href=\"").append((String)name0).append("\">").append((String)name0).append("</a></li>").toString(), ClassTag$.MODULE$.apply(String.class))).mkString();
                            string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(265).append("<!DOCTYPE html>\n                     |<html>\n                     |<head></head>\n                     |<body>\n                     |<ul>\n                     |").append(elements).append("\n                     |</ul>\n                     |</body>\n                     |</html>\n                 ").toString()));
                        }
                        String content = string;
                        either = package$.MODULE$.Right().apply(content);
                    } else {
                        File f0 = new File((File)f, ".directory");
                        either = f0.exists() ? (f0.isDirectory() ? package$.MODULE$.Left().apply(new StringBuilder(22).append("Woops: ").append(f.getCanonicalPath()).append(" is a directory").toString()) : FileCache.read$1(f0, links2, artifact02)) : FileCache.notFound$1(f0);
                    }
                } else {
                    either = FileCache.read$1(f, links2, artifact02);
                }
            } else {
                either = FileCache.notFound$1(f);
            }
            Left res = either;
            return new EitherT(this.S().point(res));
        }, this.sync());
    }

    @Override
    public Function1<Artifact, EitherT<F, String, String>> fetch() {
        return (Function1<Artifact, EitherT> & Serializable)a -> ((IterableOnceOps)this.cachePolicies().tail()).foldLeft(this.fetchPerPolicy((Artifact)a, (CachePolicy)this.cachePolicies().head()), (Function2<EitherT, CachePolicy, EitherT> & Serializable)(x$19, x$20) -> x$19.orElse((Function0<EitherT> & Serializable)() -> this.fetchPerPolicy((Artifact)a, (CachePolicy)x$20), this.sync()));
    }

    @Override
    public Seq<Function1<Artifact, EitherT<F, String, String>>> fetchs() {
        return (Seq)this.cachePolicies().map((Function1<CachePolicy, Function1> & Serializable)p -> (Function1<Artifact, EitherT> & Serializable)a -> this.fetchPerPolicy((Artifact)a, (CachePolicy)p));
    }

    private ExecutionContextExecutorService ec$lzycompute() {
        FileCache fileCache = this;
        synchronized (fileCache) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.ec = ExecutionContext$.MODULE$.fromExecutorService(this.pool());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.ec;
    }

    @Override
    public ExecutionContextExecutorService ec() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.ec$lzycompute() : this.ec;
    }

    public FileCache<F> withLocation(File location) {
        return new FileCache<F>(location, this.cachePolicies(), this.checksums(), this.credentials(), this.logger(), this.pool(), this.ttl(), this.localArtifactsShouldBeCached(), this.followHttpToHttpsRedirections(), this.followHttpsToHttpRedirections(), this.maxRedirections(), this.sslRetry(), this.sslSocketFactoryOpt(), this.hostnameVerifierOpt(), this.retry(), this.bufferSize(), this.classLoaders(), this.sync());
    }

    public FileCache<F> withCredentials(Seq<Credentials> credentials) {
        return new FileCache<F>(this.location(), this.cachePolicies(), this.checksums(), credentials, this.logger(), this.pool(), this.ttl(), this.localArtifactsShouldBeCached(), this.followHttpToHttpsRedirections(), this.followHttpsToHttpRedirections(), this.maxRedirections(), this.sslRetry(), this.sslSocketFactoryOpt(), this.hostnameVerifierOpt(), this.retry(), this.bufferSize(), this.classLoaders(), this.sync());
    }

    public FileCache<F> withLogger(CacheLogger logger) {
        return new FileCache<F>(this.location(), this.cachePolicies(), this.checksums(), this.credentials(), logger, this.pool(), this.ttl(), this.localArtifactsShouldBeCached(), this.followHttpToHttpsRedirections(), this.followHttpsToHttpRedirections(), this.maxRedirections(), this.sslRetry(), this.sslSocketFactoryOpt(), this.hostnameVerifierOpt(), this.retry(), this.bufferSize(), this.classLoaders(), this.sync());
    }

    public FileCache<F> withPool(ExecutorService pool) {
        return new FileCache<F>(this.location(), this.cachePolicies(), this.checksums(), this.credentials(), this.logger(), pool, this.ttl(), this.localArtifactsShouldBeCached(), this.followHttpToHttpsRedirections(), this.followHttpsToHttpRedirections(), this.maxRedirections(), this.sslRetry(), this.sslSocketFactoryOpt(), this.hostnameVerifierOpt(), this.retry(), this.bufferSize(), this.classLoaders(), this.sync());
    }

    public String toString() {
        StringBuilder b = new StringBuilder("FileCache(");
        b.append(String.valueOf(this.location()));
        b.append(", ");
        b.append(String.valueOf(this.cachePolicies()));
        b.append(", ");
        b.append(String.valueOf(this.checksums()));
        b.append(", ");
        b.append(String.valueOf(this.credentials()));
        b.append(", ");
        b.append(String.valueOf(this.logger()));
        b.append(", ");
        b.append(String.valueOf(this.pool()));
        b.append(", ");
        b.append(String.valueOf(this.ttl()));
        b.append(", ");
        b.append(String.valueOf(this.localArtifactsShouldBeCached()));
        b.append(", ");
        b.append(String.valueOf(this.followHttpToHttpsRedirections()));
        b.append(", ");
        b.append(String.valueOf(this.followHttpsToHttpRedirections()));
        b.append(", ");
        b.append(String.valueOf(this.maxRedirections()));
        b.append(", ");
        b.append(String.valueOf(this.sslRetry()));
        b.append(", ");
        b.append(String.valueOf(this.sslSocketFactoryOpt()));
        b.append(", ");
        b.append(String.valueOf(this.hostnameVerifierOpt()));
        b.append(", ");
        b.append(String.valueOf(this.retry()));
        b.append(", ");
        b.append(String.valueOf(this.bufferSize()));
        b.append(", ");
        b.append(String.valueOf(this.classLoaders()));
        b.append(", ");
        b.append(String.valueOf(this.sync()));
        b.append(")");
        return b.toString();
    }

    public boolean canEqual(Object obj) {
        return obj != null && obj instanceof FileCache && true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!this.canEqual(obj)) return false;
        FileCache other = (FileCache)obj;
        if (!true) return false;
        File file = this.location();
        File file2 = other.location();
        if (file == null) {
            if (file2 != null) {
                return false;
            }
        } else if (!((Object)file).equals(file2)) return false;
        Seq<CachePolicy> seq = this.cachePolicies();
        Seq<CachePolicy> seq2 = other.cachePolicies();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Seq<Option<String>> seq3 = this.checksums();
        Seq<Option<String>> seq4 = other.checksums();
        if (seq3 == null) {
            if (seq4 != null) {
                return false;
            }
        } else if (!seq3.equals(seq4)) return false;
        Seq<Credentials> seq5 = this.credentials();
        Seq<Credentials> seq6 = other.credentials();
        if (seq5 == null) {
            if (seq6 != null) {
                return false;
            }
        } else if (!seq5.equals(seq6)) return false;
        CacheLogger cacheLogger = this.logger();
        CacheLogger cacheLogger2 = other.logger();
        if (cacheLogger == null) {
            if (cacheLogger2 != null) {
                return false;
            }
        } else if (!cacheLogger.equals(cacheLogger2)) return false;
        ExecutorService executorService = this.pool();
        ExecutorService executorService2 = other.pool();
        if (executorService == null) {
            if (executorService2 != null) {
                return false;
            }
        } else if (!executorService.equals(executorService2)) return false;
        Option<Duration> option = this.ttl();
        Option<Duration> option2 = other.ttl();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (this.localArtifactsShouldBeCached() != other.localArtifactsShouldBeCached()) return false;
        if (this.followHttpToHttpsRedirections() != other.followHttpToHttpsRedirections()) return false;
        if (this.followHttpsToHttpRedirections() != other.followHttpsToHttpRedirections()) return false;
        Option<Object> option3 = this.maxRedirections();
        Option<Object> option4 = other.maxRedirections();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (this.sslRetry() != other.sslRetry()) return false;
        Option<SSLSocketFactory> option5 = this.sslSocketFactoryOpt();
        Option<SSLSocketFactory> option6 = other.sslSocketFactoryOpt();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        Option<HostnameVerifier> option7 = this.hostnameVerifierOpt();
        Option<HostnameVerifier> option8 = other.hostnameVerifierOpt();
        if (option7 == null) {
            if (option8 != null) {
                return false;
            }
        } else if (!option7.equals(option8)) return false;
        if (this.retry() != other.retry()) return false;
        if (this.bufferSize() != other.bufferSize()) return false;
        Seq<ClassLoader> seq7 = this.classLoaders();
        Seq<ClassLoader> seq8 = other.classLoaders();
        if (seq7 == null) {
            if (seq8 != null) {
                return false;
            }
        } else if (!seq7.equals(seq8)) return false;
        Sync<F> sync = this.sync();
        Sync<F> sync2 = other.sync();
        if (sync == null) {
            if (sync2 == null) return true;
            return false;
        } else {
            if (!sync.equals(sync2)) return false;
            return true;
        }
    }

    public int hashCode() {
        int code = 17 + Statics.anyHash("FileCache");
        code = 37 * code + Statics.anyHash(this.location());
        code = 37 * code + Statics.anyHash(this.cachePolicies());
        code = 37 * code + Statics.anyHash(this.checksums());
        code = 37 * code + Statics.anyHash(this.credentials());
        code = 37 * code + Statics.anyHash(this.logger());
        code = 37 * code + Statics.anyHash(this.pool());
        code = 37 * code + Statics.anyHash(this.ttl());
        code = 37 * code + (this.localArtifactsShouldBeCached() ? 1231 : 1237);
        code = 37 * code + (this.followHttpToHttpsRedirections() ? 1231 : 1237);
        code = 37 * code + (this.followHttpsToHttpRedirections() ? 1231 : 1237);
        code = 37 * code + Statics.anyHash(this.maxRedirections());
        code = 37 * code + this.sslRetry();
        code = 37 * code + Statics.anyHash(this.sslSocketFactoryOpt());
        code = 37 * code + Statics.anyHash(this.hostnameVerifierOpt());
        code = 37 * code + this.retry();
        code = 37 * code + this.bufferSize();
        code = 37 * code + Statics.anyHash(this.classLoaders());
        code = 37 * code + Statics.anyHash(this.sync());
        return 37 * code;
    }

    @Override
    public String productPrefix() {
        return "FileCache";
    }

    @Override
    public int productArity() {
        return 18;
    }

    @Override
    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this.location();
                break;
            }
            case 1: {
                object = this.cachePolicies();
                break;
            }
            case 2: {
                object = this.checksums();
                break;
            }
            case 3: {
                object = this.credentials();
                break;
            }
            case 4: {
                object = this.logger();
                break;
            }
            case 5: {
                object = this.pool();
                break;
            }
            case 6: {
                object = this.ttl();
                break;
            }
            case 7: {
                object = BoxesRunTime.boxToBoolean(this.localArtifactsShouldBeCached());
                break;
            }
            case 8: {
                object = BoxesRunTime.boxToBoolean(this.followHttpToHttpsRedirections());
                break;
            }
            case 9: {
                object = BoxesRunTime.boxToBoolean(this.followHttpsToHttpRedirections());
                break;
            }
            case 10: {
                object = this.maxRedirections();
                break;
            }
            case 11: {
                object = BoxesRunTime.boxToInteger(this.sslRetry());
                break;
            }
            case 12: {
                object = this.sslSocketFactoryOpt();
                break;
            }
            case 13: {
                object = this.hostnameVerifierOpt();
                break;
            }
            case 14: {
                object = BoxesRunTime.boxToInteger(this.retry());
                break;
            }
            case 15: {
                object = BoxesRunTime.boxToInteger(this.bufferSize());
                break;
            }
            case 16: {
                object = this.classLoaders();
                break;
            }
            case 17: {
                object = this.sync();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(n2));
            }
        }
        return object;
    }

    public static final /* synthetic */ boolean $anonfun$filePerPolicy0$5(char x$9) {
        return x$9 != '-';
    }

    private static final Seq checksumErrors$1(Seq checksumResults$1) {
        return (Seq)checksumResults$1.collect(new Serializable(null){

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends Option<Tuple3<String, String, Option<Option<ArtifactError>>>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Tuple3 tuple3;
                void var3_13;
                boolean bl = false;
                Some some = null;
                A1 A1 = x1;
                if (A1 instanceof Some) {
                    bl = true;
                    some = (Some)A1;
                    Tuple3 tuple32 = (Tuple3)some.value();
                    if (tuple32 != null) {
                        String c = (String)tuple32._1();
                        String url = (String)tuple32._2();
                        Option option = (Option)tuple32._3();
                        if (None$.MODULE$.equals(option)) {
                            Tuple2<String, String> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(c), new StringBuilder(15).append(url).append(" not downloaded").toString());
                            return var3_13;
                        }
                    }
                }
                if (bl && (tuple3 = (Tuple3)some.value()) != null) {
                    Some some2;
                    Option option;
                    String c = (String)tuple3._1();
                    Option option2 = (Option)tuple3._3();
                    if (option2 instanceof Some && (option = (Option)(some2 = (Some)option2).value()) instanceof Some) {
                        Some some3 = (Some)option;
                        ArtifactError e = (ArtifactError)some3.value();
                        Tuple2<String, String> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(c), e.describe());
                        return var3_13;
                    }
                }
                B1 B1 = function1.apply(x1);
                return var3_13;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Option<Tuple3<String, String, Option<Option<ArtifactError>>>> x1) {
                boolean bl = false;
                Some some = null;
                Option<Tuple3<String, String, Option<Option<ArtifactError>>>> option = x1;
                if (option instanceof Some) {
                    Option option2;
                    bl = true;
                    some = (Some)option;
                    Tuple3 tuple3 = (Tuple3)some.value();
                    if (tuple3 != null && None$.MODULE$.equals(option2 = (Option)tuple3._3())) {
                        return true;
                    }
                }
                if (!bl) return false;
                Tuple3 tuple3 = (Tuple3)some.value();
                if (tuple3 == null) return false;
                Option option3 = (Option)tuple3._3();
                if (!(option3 instanceof Some)) return false;
                Some some2 = (Some)option3;
                Option option4 = (Option)some2.value();
                if (!(option4 instanceof Some)) return false;
                return true;
            }
        });
    }

    private static final Left notFound$1(File f) {
        return package$.MODULE$.Left().apply(new StringBuilder(10).append(f.getCanonicalPath()).append(" not found").toString());
    }

    private static final Either read$1(File f, boolean links$1, Artifact artifact0$1) {
        Either either;
        try {
            String string;
            if (links$1) {
                File linkFile = FileCache$.MODULE$.auxiliaryFile(f, "links");
                String string2 = f.getName();
                String string3 = ".directory";
                string = !(string2 != null ? !string2.equals(string3) : string3 != null) && linkFile.isFile() ? new String(Files.readAllBytes(linkFile.toPath()), StandardCharsets.UTF_8) : WebPage$.MODULE$.listElements(artifact0$1.url(), new String(Files.readAllBytes(f.toPath()), StandardCharsets.UTF_8)).mkString("\n");
            } else {
                string = new String(Files.readAllBytes(f.toPath()), StandardCharsets.UTF_8);
            }
            String content = string;
            either = package$.MODULE$.Right().apply(content);
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            Throwable e = option.get();
            Left left = package$.MODULE$.Left().apply(new StringBuilder(24).append("Could not read (file:").append(f.getCanonicalPath()).append("): ").append(e.getMessage()).toString());
            either = left;
        }
        return either;
    }

    public FileCache(File location, Seq<CachePolicy> cachePolicies, Seq<Option<String>> checksums, Seq<Credentials> credentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int retry, int bufferSize, Seq<ClassLoader> classLoaders, Sync<F> sync) {
        this.location = location;
        this.cachePolicies = cachePolicies;
        this.checksums = checksums;
        this.credentials = credentials;
        this.logger = logger;
        this.pool = pool;
        this.ttl = ttl;
        this.localArtifactsShouldBeCached = localArtifactsShouldBeCached;
        this.followHttpToHttpsRedirections = followHttpToHttpsRedirections;
        this.followHttpsToHttpRedirections = followHttpsToHttpRedirections;
        this.maxRedirections = maxRedirections;
        this.sslRetry = sslRetry;
        this.sslSocketFactoryOpt = sslSocketFactoryOpt;
        this.hostnameVerifierOpt = hostnameVerifierOpt;
        this.retry = retry;
        this.bufferSize = bufferSize;
        this.classLoaders = classLoaders;
        this.sync = sync;
        Product.$init$(this);
        this.checksums0 = checksums.isEmpty() ? (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new None$[]{None$.MODULE$})) : checksums;
        this.actualChecksums = (Seq)((SeqOps)this.checksums0().flatMap((Function1<Option, Seq> & Serializable)x$2 -> Option$.MODULE$.option2Iterable(x$2).toSeq())).distinct();
    }
}

