/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependencies.aether;

import io.github.ascopes.protobufmavenplugin.dependencies.DependencyResolutionDepth;
import io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifact;
import io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifactPathResolver;
import io.github.ascopes.protobufmavenplugin.dependencies.aether.AetherArtifactMapper;
import io.github.ascopes.protobufmavenplugin.dependencies.aether.AetherDependencyManagement;
import io.github.ascopes.protobufmavenplugin.dependencies.aether.AetherResolver;
import io.github.ascopes.protobufmavenplugin.dependencies.aether.ProtobufMavenPluginRepositorySession;
import io.github.ascopes.protobufmavenplugin.utils.ResolutionException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.sisu.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Integrates with Eclipse Aether to resolve and download dependencies locally")
@MojoExecutionScoped
@Named
final class AetherMavenArtifactPathResolver
implements MavenArtifactPathResolver {
    private static final Logger log = LoggerFactory.getLogger(AetherMavenArtifactPathResolver.class);
    private final MavenSession mavenSession;
    private final AetherArtifactMapper aetherMapper;
    private final AetherDependencyManagement aetherDependencyManagement;
    private final AetherResolver aetherResolver;

    @Inject
    AetherMavenArtifactPathResolver(MavenSession mavenSession, RepositorySystem repositorySystem) {
        this.mavenSession = mavenSession;
        RepositorySystemSession repositorySession = mavenSession.getRepositorySession();
        ProtobufMavenPluginRepositorySession repositorySystemSession = new ProtobufMavenPluginRepositorySession(repositorySession);
        ArtifactTypeRegistry artifactTypeRegistry = repositorySystemSession.getArtifactTypeRegistry();
        this.aetherMapper = new AetherArtifactMapper(artifactTypeRegistry);
        this.aetherDependencyManagement = new AetherDependencyManagement(mavenSession, this.aetherMapper);
        List remoteRepositories = mavenSession.getCurrentProject().getRemoteProjectRepositories();
        this.aetherResolver = new AetherResolver(repositorySystem, repositorySystemSession, remoteRepositories);
        log.debug("Using remote repositories: {}", (Object)remoteRepositories);
        log.debug("Using repository system session: {}", (Object)repositorySystemSession);
    }

    @Override
    public Path resolveArtifact(MavenArtifact mavenArtifact) throws ResolutionException {
        log.debug("Resolving artifact: {}", (Object)mavenArtifact);
        Artifact unresolvedArtifact = this.aetherMapper.mapPmpArtifactToEclipseArtifact(mavenArtifact);
        Artifact resolvedArtifact = this.aetherResolver.resolveRequiredArtifact(unresolvedArtifact);
        return this.aetherMapper.mapEclipseArtifactToPath(resolvedArtifact);
    }

    @Override
    public List<Path> resolveDependencies(Collection<? extends MavenArtifact> artifacts, DependencyResolutionDepth defaultDepth, Set<String> dependencyScopes, boolean includeProjectArtifacts, boolean failOnInvalidDependencies) throws ResolutionException {
        ArrayList<Dependency> unresolvedDependencies = new ArrayList<Dependency>();
        artifacts.stream().peek(artifact -> log.debug("Resolving artifact as dependency: {}", artifact)).map(artifact -> this.aetherMapper.mapPmpArtifactToEclipseDependency((MavenArtifact)artifact, defaultDepth)).map(this.aetherDependencyManagement::fillManagedAttributes).forEach(unresolvedDependencies::add);
        Stream<Artifact> resolvedArtifacts = this.aetherResolver.resolveDependencies(unresolvedDependencies, dependencyScopes, failOnInvalidDependencies).stream();
        if (includeProjectArtifacts) {
            log.debug("Querying project dependencies from Maven model...");
            Stream<Artifact> projectArtifacts = this.mavenSession.getCurrentProject().getArtifacts().stream().filter(artifact -> dependencyScopes.contains(artifact.getScope())).peek(artifact -> log.trace("Including project artifact: {}", artifact)).map(this.aetherMapper::mapMavenArtifactToEclipseArtifact);
            resolvedArtifacts = Stream.concat(projectArtifacts, resolvedArtifacts);
        }
        return resolvedArtifacts.collect(AetherDependencyManagement.deduplicateArtifacts()).values().stream().map(this.aetherMapper::mapEclipseArtifactToPath).collect(Collectors.toUnmodifiableList());
    }
}

